AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:html-browser-converter'], function () {
    const HtmlBrowserConverter = require('jira/editor/util/html-browser-converter');

    module('Html browser converter', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    /**
     * sometimes browsers try to "fix" html markup before inserting it in to the dom.
     * eg. sometimes <!-- --!> will be changed to <!-- --> resulting in the markup following --!> become uncommented.
     * Tests if converter returns browser rendered html markup.
     *
     * This test is browser-implementation specific and can fail after browser bump (if html rendering of browser gets changed).
     */
    test("Verify convert", function (assert) {
        const xss =         '<img src onerror=alert(1)> <!-- --!> <img src onerror=alert(2)> --> <![CDATA[ --!><img src onerror=alert(3)> ]]>';
        const expected =    '<img src=\"\" onerror=\"alert(1)\"> <!-- --> <img src=\"\" onerror=\"alert(2)\"> --&gt; <!--[CDATA[ --!--><img src=\"\" onerror=\"alert(3)\"> ]]&gt;'

        const converted = HtmlBrowserConverter.convert(xss);

        assert.equal(converted, expected)
    });

    test("Verify exception handling", function (assert) {
        var dummyNode = {};
        //yui compiler complains on .throws()
        var setInnerHtml = this.sandbox.stub()['throws']();
        Object.defineProperty(dummyNode, 'innerHTML', {
            set: setInnerHtml
        });
        this.sandbox.stub(document, "createElement").returns(dummyNode);

        const converted = HtmlBrowserConverter.convert("test");

        assert.equal(converted, "");
        sinon.assert.calledOnce(setInnerHtml);
    });
});
