define("jira/editor/plugins/prevent-default", [
    "jira/editor/tinymce",
    "jquery"
], function (tinymce,
             $) {
    "use strict";

    tinymce.create('tinymce.plugins.jira.PreventDefaultPlugin', {
        init: function (ed) {
            var settings = ed.settings;

            ed.on('init', function () {
                var controller = ed.getBody()._controller;
                if (controller && controller.$textarea && controller.$textarea.get(0)) {
                    var doc = controller.$textarea.get(0).ownerDocument;
                    if (doc) {
                        var selector = settings.preventdefault.selector;
                        $(doc).on("click", selector, function (e) {
                            e.preventDefault();
                        });
                    }
                }
            });
        }
    });

    tinymce.PluginManager.add('jira.preventdefault', tinymce.plugins.jira.PreventDefaultPlugin);
    tinymce.PluginManager.urls["jira.preventdefault"] = true;

    return {
        configure: function (instance, settings) {
            settings.plugins.push('jira.preventdefault');

            settings.preventdefault = {selector: "a[contenteditable=false]"};
        }
    };
})
;