define('jira/editor/fsm/states/state-hidden-intersection-observer', [
    'jira/editor/fsm/events'
], function (Events) {

    var Observer = function (element, FSM) {
        this.element = element;
        this.FSM = FSM;
    };

    Observer.prototype.isIntersectionObserverSupported = function () {
        return "IntersectionObserver" in window &&
            "IntersectionObserverEntry" in window &&
            "intersectionRatio" in window.IntersectionObserverEntry.prototype;
    };

    Observer.prototype.observe = function () {
        if (!this.isIntersectionObserverSupported()) {
            return false;
        }

        var options = {
            root: null,
            rootMargin: "0px",
            threshold: 0
        };

        function handleIntersect(entries, observer) {
            entries.forEach(function (entry) {
                if (entry.isIntersecting) {
                    this.FSM.triggerEvent(Events.VISIBLE);
                }
            }.bind(this));
        }

        this.observer = new window.IntersectionObserver(handleIntersect.bind(this), options);
        this.observer.observe(this.element);

        return true;
    };

    Observer.prototype.cleanup = function () {
        if (this.observer) {
            this.observer.disconnect();
            delete this.observer;
        }
    };

    return Observer;
});
