define('jira/editor/fsm/states/wrap', [
    'jira/editor/fsm/states/state',
    'jira/editor/fsm/states/detached',
    'jira/editor/fsm/states/mode-text',
    'jira/editor/fsm/states/mode-visual',
    'jira/editor/fsm/events',
    'jira/editor/constants',
    'jira/editor/controller',
    'jira/editor/height-helper',
    'jira/editor/analytics',
    'underscore',
    'jquery'
], function(
    State,
    StateDetached,
    StateText,
    StateVisual,
    Events,
    Constants,
    controller,
    HeightHelper,
    Analytics,
    _,
    $
) {
    return function(element, textarea) {
        var $textarea = $(textarea);

        Analytics.mark("rte-init");
        $textarea.addClass("wiki-edit-wrapped");

        new HeightHelper($textarea).setHeights();

        element.textarea = textarea;
        element.$textarea = $textarea;

        var toggleTabs = controller._createTabs($(element), $textarea);
        controller._initModes($(element), $textarea, toggleTabs);

        toggleTabs.on("change", function (mode) {
            element.FSM.triggerEvent(Events.TABS_CHANGE, mode);
        });

        toggleTabs.getMode().then(_.debounce(function (mode) {
            element.FSM.triggerEvent(Events.TABS_CHANGE, mode);
        }));

        return State("Wrap", function (eventType, eventObject) {
            if (eventType === Events.DETACHED && eventObject === element) {
                return StateDetached(element);
            }

            if (eventType === Events.TABS_CHANGE && eventObject === Constants.Modes.VISUAL) {
                return StateVisual(element);
            } else if (eventType === Events.TABS_CHANGE && eventObject === Constants.Modes.TEXT) {
                return StateText(element);
            }
        });
    };
});
