define("jira/editor/resources", [
    "jira/editor/tinymce",
    "jira/editor/wrm",
    "wrm/require",
    "jquery"
], function(
    tinymce,
    wrmResources,
    wrmRequire,
    $
) {
    "use strict";

    var EditorResources = {};

    var injected = {};

    EditorResources.loadPlugins = function(plugins) {
        var resourceKeys = plugins.filter(function(plugin) {
            return plugin.resource;
        }).map(function (plugin) {
            // need to alter internal MCE structure, so it won't load any files
            tinymce.PluginManager.urls[plugin.name] = plugin.resource;

            return "wr!" + plugin.resource;
        });
        return resourceKeys.length > 0 ? wrmRequire(resourceKeys) : new $.Deferred().resolve();
    };

    EditorResources.require = function(resources) {
        return wrmRequire(
            resources.filter(function(resource) {
                return !injected[resource];
            }).map(function(resource) {
                return 'wr!' + resource;
            })
        );
    };

    EditorResources.loadCssResources = function() {
        return new $.Deferred().resolve(fixURIs(wrmResources.getResources())).promise();
    };

    return EditorResources;


    /**
     * TinyMCE bug: https://github.com/tinymce/tinymce/issues/3298
     * Issue: https://bulldog.internal.atlassian.com/browse/MNSTR-439
     *
     * @param URIs
     * @returns {Array.String}
     */
    function fixURIs(URIs) {
        if (typeof URIs !== 'object' || !URIs.length) {
            return [];
        }
        return URIs.map(function(uri) {
            return uri.replace(',', '%2C');
        });
    }
});