AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:instance"], function () {
    "use strict";

    var Backbone = require("backbone");
    var jQuery = require("jquery");
    var _ = require("underscore");
    var contextPath = require("wrm/context-path");


    module("EditorInstance", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.editor = _.extend({
                getContent: function () {
                    return _.uniqueId();
                },
                getBody: function () {},
                insertContent: this.sandbox.stub(),
                focus: this.sandbox.stub(),
                selection: {
                    getStart: this.sandbox.stub(),
                },
                nodeChanged: this.sandbox.stub()
            }, Backbone.Events);

            this.mockedContext = AJS.test.mockableModuleContext();

            this.dialogMock = {
                current: {
                    hide: sinon.spy(),
                },
                HIDE_REASON: {
                    cancel: 'cancel',
                }
            };

            this.mockedContext.mock("jira/dialog/dialog", this.dialogMock);

            var EditorInstance = this.mockedContext.require("jira/editor/instance");

            this.editorInstance = new EditorInstance(this.editor);
            this.editorInstance.init(this.editor);
        },
        teardown: function () {
            this.sandbox.restore();
        },
        assertFocusNotApplied: function () {
            var returnValue = this.editorInstance.focus();

            sinon.assert.notCalled(this.editor.focus);
            sinon.assert.notCalled(this.editor.nodeChanged);
            strictEqual(returnValue, this.editorInstance, 'focus method should return EditorInstance');
        }
    });

    test("Should hide the dialog when ESC key is being pressed", function () {
        var e = new jQuery.Event("keydown");
        e.keyCode = 27;

        this.editor.trigger('keydown', e);

        sinon.assert.calledOnce(this.dialogMock.current.hide);
    });

    test("Should handle focus when editor is initialised", function () {
        this.editor.initialized = true;

        var returnValue = this.editorInstance.focus();

        sinon.assert.calledOnce(this.editor.focus);
        sinon.assert.calledOnce(this.editor.nodeChanged);
        strictEqual(returnValue, this.editorInstance, 'focus method should return EditorInstance');
    });

    test("Should not apply focus when editor is uninitialised, or destroyed, or removed", function () {
        this.editor.initialized = false;
        this.assertFocusNotApplied();

        this.editor.initialized = true;
        this.editor.removed = true;
        this.assertFocusNotApplied();

        this.editor.initialized = true;
        this.editor.removed = false;
        this.editor.destroyed = true;
        this.assertFocusNotApplied();
    });

    test("Blur trigger change event on editor instance", function () {
        this.editorInstance.trigger = sinon.spy();

        this.editor.trigger("blur");

        ok(this.editorInstance.trigger.calledOnce);
    });

    test("Placeholder image should be rendered when there is no href on attachment", function () {
        var attachedImageSpy = this.sandbox.spy(JIRA.Editor.Tags.Templates, "attachedImage");

        this.editorInstance.executeOperation('attachment', {
            attachment: {
                type: 'image',
                name: 'attachmentName',
                thumbnailable: true
            }
        });

        ok(JIRA.Editor.Tags.Templates.attachedImage.calledOnce);
        ok(this.editor.insertContent.calledOnce);
        sinon.assert.calledWith(attachedImageSpy, {
            source: contextPath() + '/images/icons/attach/image.gif',
            filename: "attachmentName"
        });
    });
});