define("jira/editor/customizer", ['jira/util/logger'], function(logger) {
    "use strict";

    var callbackList = [];

    var EditorCustomizer = {};
    /**
     * Provided callback function will be called before TinyMCE initialization
     *  with the following arguments:
     * - tinymceSettings
     *   Settings used for initialization of TinyMCE instance.
     *   The object can be altered and changes will affect TinyMCE instance.
     *   One can obtain target element from `tinymceSettings.target` property.
     * - tinymce TinyMCE global object
     * - SchemaBuilder it can be used to add support for custom elements
     *
     * @param {Function} callback signature (tinymceSettings, tinymce, SchemaBuilder)
     * @param {Object=} context this keyword of the callback will be set to the provided value
     * @returns {Boolean} true if callback was added, false otherwise
     */
    EditorCustomizer.customizeSettings = function (callback, context) {
        if (typeof callback !== 'function') {
            logger.error('callback has to be a function');
            return false;
        }
        if (typeof context === 'object') {
            callback = callback.bind(context);
        }

        callbackList.push(callback);
        return true;
    };

    EditorCustomizer.getCustomizeSettingCallbacks = function () {
        return callbackList.slice(0);   // return a copy of callbackList
    };

    return EditorCustomizer;
});