AJS.test.require([
    'com.atlassian.jira.plugins.jira-editor-plugin:customization'
], function () {
    "use strict";

    /**
     * Call it with the module context.
     */
    function setup() {
        this.context = AJS.test.mockableModuleContext();
        this.sandbox = sinon.sandbox.create();

        this.logger = {
            error: sinon.spy()
        };

        this.context.mock("jira/util/logger", this.logger);

        this.Customizer = this.context.require('jira/editor/customizer');
        this.customizeSettings = this.Customizer.customizeSettings;
        this.getCallbacks = this.Customizer.getCustomizeSettingCallbacks;
        this.getFirstCallback = function () {
            var fn = (this.getCallbacks())[0];
            return fn();
        }

        this.fn = function() { return this; };
    }

    module('Customizer: customizeSettings', {
        setup: function() {
            setup.call(this);
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Should not add a callback which is not a function', function () {
        ok(!this.customizeSettings(0));
        ok(!this.customizeSettings(true));
        ok(!this.customizeSettings(null));
        ok(!this.customizeSettings({}));
        ok(!this.customizeSettings([]));
        ok(!this.customizeSettings(''));

        sinon.assert.alwaysCalledWith(this.logger.error, sinon.match('function'));
    });

    test('Should add a callback with default context', function () {
        ok(this.customizeSettings(this.fn), 'Should add a callback');
        strictEqual(this.getFirstCallback(), undefined, 'Callback should be called with the default context, ie. undefined in strict mode');
    });

    test('Should add a callback with provided context', function () {
        var context = {};

        ok(this.customizeSettings(this.fn, context), 'Should add a callback');
        strictEqual(this.getFirstCallback(), context, 'Callback should be called with the provided context');
    });


    module('Customizer: getCustomizeSettingCallbacks', {
        setup: function() {
            setup.call(this);
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Should return an array of callbacks', function () {
        ok(this.getCallbacks().length === 0, 'Array of callbacks should be empty');

        var fn1 = function() {};
        this.customizeSettings(fn1);
        ok(this.getCallbacks().length === 1, 'Array of callbacks should contain one element');
        deepEqual(this.getCallbacks(), [fn1]);

        var fn2 = function() {};
        this.customizeSettings(fn2);
        ok(this.getCallbacks().length === 2, 'Array of callbacks should contain two elements');
        deepEqual(this.getCallbacks(), [fn1, fn2]);
    });

    test('Should return a copy of underlying array', function() {
        var emptyList = this.getCallbacks();
        ok(emptyList !== this.getCallbacks(), 'Lists should not be the same')

        this.customizeSettings(this.fn);
        ok(emptyList.length === 0, 'Adding new callback should not alter previously returned empty list')

        var list = this.getCallbacks();
        this.customizeSettings(this.fn);
        ok(list.length === 1, 'Adding new callback should not alter previously returned non-empty list')

        ok(this.getCallbacks().length === 2, 'Getting callbacks should not alter underlying list');
    });
});