/**
 * @deprecated This module is deprecated and therefore should not be extended,
 * any new behavior should be applied through state machine defined in {@link js/fsm/*} modules.
 */
define("jira/editor/controller", [
    "jira/editor/analytics",
    "jira/editor/constants",
    "jira/editor/registry",
    "jira/editor/ui/toggle-tabs",
    "jira/editor/ui/undo-redo-buttons",
    "jira/editor/ui/toolbar/clear-formatting",
    "jira/editor/undomanager",
    "jira/editor/ui/button-bar-decorator",
    "jira/editor/height-helper",
    "wrm/require",
    "jquery",
    "underscore",
    "jira/editor/util/temporaryAttachment"
], function(
    Analytics,
    Constants,
    editorRegistry,
    ToggleTabs,
    UndoRedoButtons,
    ClearFormatting,
    UndoManager,
    ButtonBarDecorator,
    HeightHelper,
    wrmRequire,
    $,
    _,
    temporaryAttachmentUtil
) {
    var WRAP_MARK = "jiraEditorWrap";
    var IMMEDIATE_PARA = '>p:first-child:last-child';
    var BORDER_SIZE = -2;
    var Modes = Constants.Modes;

    return {
        init: function() {
        },

        initResources: function() {
            if (this.webResources) {
                return this.webResources;
            }

            return this.webResources = wrmRequire([
                'wrc!jira.rich.editor.api',
                'wrc!jira.rich.editor'
            ])
        },

        _createTabs: function ($richEditor, $textarea) {
            var textarea = $textarea[0];
            var toggleTabs = $textarea.data("toggleTabs");
            if (!toggleTabs) {
                $textarea.data("toggleTabs", toggleTabs = new ToggleTabs(textarea));
            }

            toggleTabs.getMode().then(function (mode) {
                if ($textarea.is(':visible') && (mode === Modes.TEXT)) {
                    Analytics.sendEvent("editor.instance.init.source");
                    Analytics.sendEvent("bundled.editor.instance.init.source");
                }
            });

            return toggleTabs;
        },

        _createUndoManager: function ($richEditor, $textarea, toggleTabs, mode) {
            var textarea = $textarea[0];
            var undoManager = $textarea.data("undoManager");
            if (!undoManager) {
                undoManager = new UndoManager({textarea: textarea, mode: mode});
                $textarea.data("undoManager", undoManager);
            }
            return undoManager;
        },

        _createUndoRedoButtons: function ($richEditor, $textarea, toggleTabs, undoManager) {
            var textarea = $textarea[0];
            new ButtonBarDecorator().decorateButtonBars(toggleTabs.$tabs);
            var undoRedoButtons = $textarea.data("undoRedoButtons");
            if (!undoRedoButtons) {
                undoRedoButtons = new UndoRedoButtons({textarea: textarea, undoManager: undoManager});
                undoRedoButtons.render();
                $textarea.data("undoRedoButtons", undoRedoButtons);
            }
            return undoRedoButtons;
        },

        _initModes: function ($richEditor, $textarea, toggleTabs) {
            var initVisualModeClosure = _.partial(initVisualModeForRegistry, $textarea[0], toggleTabs);

            toggleTabs.getMode().then(function (mode) {
                initTextModeForRegistry($textarea[0], mode);

                var undoManager = this._createUndoManager($richEditor, $textarea, toggleTabs, mode);
                var undoRedoButtons = this._createUndoRedoButtons($richEditor, $textarea, toggleTabs, undoManager);

                if (mode === Modes.VISUAL) {
                    undoManager.shouldRestoreHistory(true);
                    this.initResources();
                    this.initEditor($richEditor, $textarea, toggleTabs, undoManager, undoRedoButtons, true)
                        .done(initVisualModeClosure);
                } else {
                    // MNSTR-1356: brings cross-browser consistency WRT setting caret at the beginning when starting with Text mode
                    $textarea.setCaretToPosition(0);

                    toggleTabs.once("change", function (mode) {
                        toggleTabs.disable();
                        undoRedoButtons.disable();

                        if (mode === Modes.VISUAL) {
                            Analytics.sendEvent("editor.instance.switch.wysiwyg");
                            Analytics.sendEvent("bundled.editor.instance.switch.wysiwyg");

                            this.initEditor($richEditor, $textarea, toggleTabs, undoManager, undoRedoButtons)
                                .done(initVisualModeClosure)
                                .always(function () {
                                    toggleTabs.enable();
                                    undoRedoButtons.updateUI();
                                }).done(function (instance) {
                                    instance.focus();
                                });
                        }
                    }.bind(this), this);
                    undoRedoButtons.updateUI();
                }
            }.bind(this));
        },

        _renderMarkup: function ($richEditor, $textarea, initVisual) {
            var textarea = $textarea[0];
            var markup = textarea.value;
            var renderParams = this.getRenderParams(textarea);

            if (!initVisual) {
                return this.renderMarkup(markup, renderParams);
            }
            if ($richEditor.data('content-present')) {
                var html = $richEditor.html();
                $richEditor.empty();
                return new $.Deferred().resolve(this._postProcessRendered($(new DOMParser().parseFromString(html, 'text/html').body))).promise();
            } else {
                return this.renderMarkup(markup, renderParams);
            }
        },

        initEditor: function ($richEditor, $textarea, toggleTabs, undoManager, undoRedoButtons, initVisual) {
            var result = new $.Deferred();

            var textarea = $textarea[0];
            var richEditor = $richEditor[0];
            if ($richEditor.data("textarea") === textarea) {
                return new $.Deferred().reject().promise();
            }
            var renderMarkup = this._renderMarkup($richEditor, $textarea, initVisual);

            new HeightHelper(textarea).setHeights($richEditor, BORDER_SIZE);

            toggleTabs.disable();

            var renderParams = this.getRenderParams(textarea);
            $richEditor.data("textarea", textarea)
                .data("renderParams", renderParams);


            if (!richEditor.loadingStart()) {
                return new $.Deferred().reject().promise();
            } else {
                this.require(['jira/editor/create', 'jira/editor/saving-kb-shortcuts'], function (EditorCreate, SavingKbShortcuts) {
                    EditorCreate.builder()
                        .withElement(richEditor)
                        .withMeta(richEditor.$textarea.data())
                        .withPlugin("jira/editor/plugins/mentions/jira-mentions")
                        .withPlugin("jira/editor/plugins/prevent-default")
                        .withPlugin("jira/editor/plugins/paste")
                        .withPlugin("jira/editor/plugins/wiki-autoformat")
                        .withPlugin("jira/editor/plugins/editor-content-postprocess")
                        .withPlugin("jira/editor/plugins/toolbar-sync")
                        .build().progress(function(instance) {
                        richEditor.setInstance(instance);
                    }).then(function (instance) {
                        // make textarea invisible, but don't hide it, so it does not loose focus
                        richEditor.loadingStop();

                        instance.on("content", richEditor.serialize, richEditor);

                        if (richEditor.$textarea.is(document.activeElement)) {
                            // in case textarea was already focused and had some selection set
                            richEditor.syncSelection(richEditor.$textarea[0]);
                        }

                        instance.on("switchMode", function (showSource) {
                            richEditor.setMode(showSource);
                        });

                        //// this should go into EditorInstance, because after successful build editor should be focusable,
                        //// but it is not
                        if (richEditor.shouldFocus()) {
                            setTimeout(function () {
                                instance.focus();
                            });
                        }

                        /*
                        MNSTR-2690 fixes some focus quirks for safari when using toolbar dropdowns
                         */
                        if (document.activeElement && $.browser.safari) {
                            document.activeElement.blur();
                        }

                        // this is needed for inline edit
                        instance.relayEvent("blur", function () {
                            richEditor.$textarea.blur();
                        });

                        // it must be the very fist keydown handler (TinyMCE internals)
                        SavingKbShortcuts.enable(richEditor);

                        var initTs = window.performance.now();
                        renderMarkup.done(function (rendered) {
                            attachVisualEditorToUndoManager(richEditor);
                            instance.setContent(rendered, null, true);
                        }).fail(function () {
                            attachVisualEditorToUndoManager(richEditor);
                            var markup = $textarea[0].value;
                            instance.setContent(markup, null, true);
                        }).always(function () {
                            richEditor.hideMask();
                            toggleTabs.enable();
                            undoRedoButtons.updateUI();
                            result.resolve(richEditor);
                            ClearFormatting.init(richEditor);

                            Analytics.oneShotMeasure("rte-init", {}, "init", true);

                            // we want to keep old event at least for some time
                            var loadTime = window.performance.now() - initTs;
                            Analytics.sendEvent("editor.instance.init.perf", {time: loadTime});
                        });

                        function attachVisualEditorToUndoManager(instance) {
                            undoManager.attachToVisualEditor(instance);
                            undoManager.setActiveMode(Modes.VISUAL);
                            undoManager.restoreUndoHistory();
                        }

                        Analytics.oneShotMeasure("rte-init", {}, "init-bare", true);
                    });
                });

                this._bindToggleTabsChange(toggleTabs, undoRedoButtons, undoManager, richEditor);

                return result.promise();
            }
        },

        _bindToggleTabsChange: function (toggleTabs, undoRedoButtons, undoManager, richEditor) {
            toggleTabs.on("change", function(mode) {
                toggleTabs.disable();
                undoRedoButtons.disable();

                var showSource = mode === Modes.TEXT;
                richEditor.setMode(showSource)
                    .done(function() {
                        undoManager.setActiveMode(mode);

                        richEditor.getInstance().trigger("tabs:changed", showSource);
                    })
                    .fail(function() {
                        // revert mode change both in editor and in tabs
                        richEditor.setMode(!showSource);
                        toggleTabs.setMode(!showSource ? Modes.TEXT : Modes.VISUAL);
                    }).always(function() {
                        toggleTabs.enable();
                        undoRedoButtons.updateUI();
                    });
            });
        },

        destroyEditor: function (richEditor) {
            var $richEditor = $(richEditor);
            var parentNode = richEditor.parentNode;
            var textarea = $richEditor.data("textarea");

            $richEditor.removeData(["textarea", "renderParams"]);

            $(textarea).data(WRAP_MARK, false);
            var toggleTabs = $(textarea).data("toggleTabs");
            toggleTabs && toggleTabs.off("change");

            textarea = textarea || parentNode.querySelector('textarea');
            if (textarea) {
                editorRegistry._unregister(textarea);
            }
        },

        getRenderParams: function (element) {
            var e = $(element);
            var issueType = e.parents('form').find("#issuetype").val();
            var formToken = temporaryAttachmentUtil.getFormToken(e);
            return {
                issueKey: this.getIssueKey(e),
                projectId: e.parents('form').find("#pid").val(),
                issueType: _.isArray(issueType) ? _.first(issueType) : issueType,
                formToken: formToken
            };
        },

        getIssueKey: function ($element) {
            if ($element.attr('data-issuekey')) {
                return $element.attr('data-issuekey');
            }

            if (JIRA && JIRA.Issue && JIRA.Issue.getIssueKey) {
                return JIRA.Issue.getIssueKey();
            }

            // last resort!
            return AJS.Meta.get("issue-key");
        },

        renderMarkup: function(markup, renderParams) {
            Analytics.mark("rte-rendermarkup");
            var result = new $.Deferred();

            var rejectMarkup = function() {
                result.reject(markup.replace(/(?:\r\n|\r|\n)/g, '<br />'));
            };

            if (!markup) {
                return result.resolve("");
            }

            this.require(['jira/editor/html-renderer'], function(htmlRenderer) {
                htmlRenderer.renderMarkup(markup, renderParams).then(function(rendered) {
                    try {
                        var $rendered = $(new DOMParser().parseFromString(rendered, 'text/html').body);
                        result.resolve(this._postProcessRendered($rendered));
                    } catch(e) {
                        result.reject(markup);
                    }
                }.bind(this), rejectMarkup);
            }.bind(this), rejectMarkup);

            return result.promise().done(function() {
                Analytics.oneShotMeasure("rte-rendermarkup");
            });
        },

        _postProcessRendered: function ($rendered) {
            // We unwrap `span.image-wrap` to solve the problem, when we insert image(which is wrapped by this span) and all
            // lately added content will be lost, 'cause it will be added as children of this span and ignored by JIRA.
            $rendered.find('span.image-wrap').replaceWith(function (index, content) {
                var $content = $(content);
                if ($content.is('img')) {
                    if (this.style['textAlign']) {
                        $content.css({'text-align': this.style['textAlign'], 'display': 'block', 'margin': '0 auto'});
                    } else if (this.style['float']) {
                        $content.css('float', this.style['float']);
                    }
                }
                return $content;
            });

            // If the block content is empty, TinyMCE removes the empty inner <div> and <pre>.
            // We add <br> to prevent this removal.
            $rendered.find('div.code.panel,div.preformatted.panel').html(function (index, content) {
                var $content = $(content);
                $content.find('pre:empty').html('<br>');
                return $content;
            });

            // even though there is css selector with first/last child, still check for text nodes
            var $immediatePara = $rendered.find(IMMEDIATE_PARA);
            if ($immediatePara.length === 1 && !$immediatePara[0].previousSibling && !$immediatePara[0].nextSibling) {
                return $immediatePara.html() || '';
            } else {
                return $rendered.html() || '';
            }
        },

        require: function(modules, fn) {
            this.initResources().then(function() {
                require(modules, fn); // eslint-disable-line module-checks/no-dynamic-require
            });
        },

        /**
         * Override wiki preview function, that's the only way(till 7.2 at least) to get issue-key for preview
         */
        overrideWikiPreview: function() {
            var wikiPreview = require('jira/wikipreview/wiki-preview');

            var override = function(prefs, ctx) {
                var $textarea = ctx.find('textarea.wiki-textfield');

                if (!$textarea.attr("data-issue-key")) {
                    var issueKey = $(prefs).find('dt:contains("issueKey")+dd').text();
                    if (issueKey) {
                        $textarea.attr("data-issue-key", issueKey);
                    }
                }

                return wikiPreview.apply(this, arguments);
            };

            AJS.namespace("jira.app.wikiPreview", null, override);
            AJS.namespace('JIRA.wikiPreview', null, override);
        }
    };

    function initTextModeForRegistry(textArea, mode) {
        if (mode === Modes.TEXT) {
            editorRegistry._registerTextMode(textArea);
        }

        if (!textArea.isListenedByRegistry) {
            editorRegistry.listenTo(textArea, 'detached', editorRegistry._unregister);
            textArea.isListenedByRegistry = true;
        }
    }

    function initVisualModeForRegistry(textArea, toggleTabs, richEditor) {
        var editorInstance = richEditor.getInstance();

        editorRegistry._registerVisualMode(editorInstance);

        toggleTabs.on('change', function onTabChangeCallback(mode) {
            editorRegistry._switchMode(textArea, mode);
        });
    }
});