define("jira/editor/analytics-shortcuts", [
    "jira/editor/analytics",
    "jira/editor/tinymce"
], function(
    Analytics,
    tinymce
) {
    var AnalyticsShortcuts =  function(editor) {
        this.editor = editor;
        editor.on("keydown", this._handle.bind(this));
    };

    AnalyticsShortcuts.prototype._handle = function(e) {
        var keyChar = String.fromCharCode(e.keyCode);
        if (tinymce.util.VK.metaKeyPressed(e)) {
            switch (keyChar) {
                case 'B':
                    Analytics.sendEvent("editor.instance.shortcut.bold");
                    break;
                case 'I':
                    Analytics.sendEvent("editor.instance.shortcut.italic");
                    break;
                case 'U':
                    Analytics.sendEvent("editor.instance.shortcut.underline");
                    break;
                case 'Z':
                    Analytics.sendEvent("editor.instance.shortcut.undo");
                    break;
                case 'Y':
                    Analytics.sendEvent("editor.instance.shortcut.redo");
                    break;
                case '0':
                    Analytics.sendEvent("editor.instance.shortcut.paragraph");
                    break;
                case '1':
                    Analytics.sendEvent("editor.instance.shortcut.heading1");
                    break;
                case '2':
                    Analytics.sendEvent("editor.instance.shortcut.heading2");
                    break;
                case '8':
                    Analytics.sendEvent("editor.instance.shortcut.code");
                    break;
                case '9':
                    Analytics.sendEvent("editor.instance.shortcut.quote");
                    break;
                case 'K':
                    Analytics.sendEvent("editor.instance.shortcut.links");
                    break;
            }
        }
        if (e.shiftKey) {
            switch (keyChar) {
                case '2':
                    Analytics.sendEvent("editor.instance.shortcut.mention");
                    break;
            }
        }
    };
    return AnalyticsShortcuts;
});