AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:converter'], function () {
    require(['jira/editor/converter/util/uri'], function(uri) {

        module('Uri');

        test("Decode uri", function () {
            equal(uri.decodeUri("normal"), "normal");
            equal(uri.decodeUri("Page+with+space"), "Page with space");
            equal(uri.decodeUri("Page%20with%20other%20space"), "Page with other space");
            equal(uri.decodeUri("P%40ge+w%21th+spec%23al+characters%21"), "P@ge w!th spec#al characters!");
            equal(uri.decodeUri("reserved+characters+hacker-_.%21%7E*%27%28+%29%2B%7C"), "reserved characters hacker-_.!~*'( )+|");
            equal(uri.decodeUri("%2A"), "*");
            equal(uri.decodeUri("hacker-_.%21%7E*%27%28%29hacker"), "hacker-_.!~*'()hacker");
        });

        test("Encode uri", function () {
            equal(uri.encodeUri("normal"), "normal");
            equal(uri.encodeUri("Page with space"), "Page+with+space");
            equal(uri.encodeUri("P@ge w!th spec#al characters!"), "P%40ge+w%21th+spec%23al+characters%21");
            equal(uri.encodeUri("reserved characters hacker-_.!~*'( )+|"), "reserved+characters+hacker-_.%21~%2A%27%28+%29%2B%7C");
            equal(uri.encodeUri("hacker-_.!~*'()hacker"), "hacker-_.%21~%2A%27%28%29hacker");
        });
    });
});