/**
 * Handle new lines merging in RTE editor.
 *
 * @module jira/editor/converter/new-lines/new-lines-merger
 */
define('jira/editor/converter/new-lines/new-lines-merger', [
    "underscore",
    'jira/editor/converter/util/strings',
    'jira/editor/converter/new-lines/new-lines'
], function (
    _,
    Strings,
    NewLines
) {

    function newLinesNumber(stack) {
        var optionalsMax = _.max(stack.filter(function (element) {
            return element.optional();
        }).map(function (element) {
            return element.newLines();
        }));

        var nonOptionalsSum = stack.filter(function (element) {
            return !element.optional();
        }).reduce(function (previous, current) {
            return previous + current.newLines();
        }, 0);

        return Math.max(nonOptionalsSum, optionalsMax);
    }

    function mergeNewLines(stack) {
        stack = _.filter(stack, function (element) {
            return element instanceof NewLines || element !== "" ;
        });

        var newLinesStack = [];
        var returnStack = [];

        for (var i = 0; i < stack.length; i++) {
            var handler = stack[i];
            if (handler instanceof NewLines) {
                newLinesStack.push(handler);
                continue;
            }

            returnStack.push(Strings.repeat("\n", newLinesNumber(newLinesStack)));
            returnStack.push(handler);

            newLinesStack = [];
        }

        return returnStack;
    }

    return {
        mergeNewLines: mergeNewLines,
        _newLinesNumber: newLinesNumber
    }
});


