AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:converter'], function () {
    var NewLines = require('jira/editor/converter/new-lines/new-lines');
    var NewLinesMerger = require('jira/editor/converter/new-lines/new-lines-merger');

    module('NewLines module', {
        newLine: function (number, optional) {
            return new NewLines(number, !!optional);
        },

        testNewLines: function (newLinesStack, requested) {
            equal(requested, NewLinesMerger._newLinesNumber(newLinesStack));
        },

        testNewLinesMerge: function (newLines, requested) {
            equal(requested, NewLinesMerger.mergeNewLines(newLines).join(""));

        }
    });

    test("Shouldn't use optional if not necessary", function () {
        this.testNewLines([
            this.newLine(4),
            this.newLine(1, true)
        ], 4);

        this.testNewLines([
            this.newLine(1),
            this.newLine(1, true)
        ], 1);
    });

    test("Should use optional if number in optional is bigger than non-optional", function () {
        this.testNewLines([
            this.newLine(1),
            this.newLine(2, true)
        ], 2);
    });

    test("Should sum all non-optional", function () {
        this.testNewLines([
            this.newLine(1),
            this.newLine(4),
            this.newLine(5)
        ], 10);
    });

    test("Should use optional with the biggest number of lines", function () {
        this.testNewLines([
            this.newLine(3, true),
            this.newLine(1),
            this.newLine(2, true)
        ], 3);
    });

    test("Should use optional with the biggest number of lines if there are only optionals", function () {
        this.testNewLines([
            this.newLine(3, true),
            this.newLine(1, true),
            this.newLine(2, true)
        ], 3);
    });

    test("Should merge sibling new lines", function () {
        this.testNewLinesMerge([
            "a",
            this.newLine(1, true),
            this.newLine(1),
            this.newLine(1),
            "b"],
            "a\n\nb"
        );
    });

    test("Should omit empty newline handlers", function () {
        this.testNewLinesMerge([
                "a",
                this.newLine(0),
                this.newLine(0, true),
                "b"],
            "ab"
        );
    });

    test("Should omit empty strings", function () {
        this.testNewLinesMerge([
                "a",
                this.newLine(1),
                "",
                this.newLine(1, true),
                "b"],
            "a\nb"
        );
    });

    test("Should handle complicated merging", function () {
        this.testNewLinesMerge([
                "a",
                this.newLine(1),
                this.newLine(2),
                "c",
                this.newLine(5, true),
                "",
                this.newLine(1),
                this.newLine(0, true),
                "b"],
            "a\n\n\nc\n\n\n\n\nb"
        );
    });
});