define("jira/editor/converter/handlers/underline-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/factories/whitespace-extractor"
], function (
    NodeHandler,
    TextHandler,
    WhitespaceExtractor
) {
    "use strict";

    /**
     * @class UnderlineHandler
     * @extends NodeHandler
     */
    var handler = NodeHandler.extend({
        init: function UnderlineHandler(node) {
            this.node = node;
        },

        before: function () {
            return TextHandler.createTextHandler('+');
        },

        after: function () {
            return TextHandler.createTextHandler('+');
        }
    });
    return WhitespaceExtractor(handler);
});