define("jira/editor/converter/handlers/table-row-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/handlers/empty-handler",
    "jira/editor/converter/new-lines/new-lines"
], function (
    NodeHandler,
    TextHandler,
    EmptyHandler,
    NewLines
) {
    "use strict";

    /**
     * @class TableRowHandler
     * @extends NodeHandler
     */
    return NodeHandler.extend({
        init: function TableRowHandler(node) {
            this.node = node;
        },

        createBeforeChild: function(childNode, childIndex, childrenTotal) {
            if (childNode.tagName === 'TH') {
                return TextHandler.createTextHandler('||');
            } else {
                return TextHandler.createTextHandler('|');
            }
        },

        newLinesAfter: function () {
            return NewLines.single();
        },

        createAfterChild: function(childNode, childIndex, childrenTotal) {
            if (childIndex === childrenTotal - 1) {
                // add closing table character only after the last TD or TH
                if (childNode.tagName === 'TH') {
                    return TextHandler.createTextHandler('||');
                } else {
                    return TextHandler.createTextHandler('|');
                }
            }
            return new EmptyHandler();
        }
    });
});