define("jira/editor/converter/handlers/paragraph-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/empty-handler",
    'jira/editor/converter/new-lines/new-lines',
    "jquery"
], function (
    NodeHandler,
    EmptyHandler,
    NewLines,
    $
) {
    "use strict";

    /**
     * @class ParagraphHandler
     * @extends NodeHandler
     */
    return NodeHandler.extend({
        init: function ParagraphHandler(node) {
            this.node = node;
        },

        newLinesBefore: function () {
            if (this.node.previousElementSibling === null && $(this.node).parents().is('td, th, .panelContent, .panel')) {
                return NewLines.empty();
            }

            // so it is not affected by pretty printed html(tinymce output)
            if (this.node.previousElementSibling !== null) {
                return NewLines.single();
            }

            return NewLines.empty();
        },

        newLinesAfter: function () {
            if ($(this.node).is(':last-child') && $(this.node).parents().is('td, th')) {
                return NewLines.empty();
            }

            return NewLines.single($(this.node).parents().is('td, th'));
        },

        before: function() {
            return new EmptyHandler();
        }
    });
});