define("jira/editor/converter/handlers/monospaced-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/factories/whitespace-extractor"
], function (
    NodeHandler,
    TextHandler
) {
    "use strict";

    /**
     * @class MonospacedHandler
     * @extends NodeHandler
     */
     var handler = NodeHandler.extend({
         init: function MonospacedHandler(node) {
             this.node = node;
         },

         before: function () {
             return TextHandler.createPreformattedTextHandler('{{');
         },

         after: function () {
             return TextHandler.createPreformattedTextHandler('}}');
         }
    });
    return handler;
});