define("jira/editor/converter/handlers/linebreak-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jquery"
], function (
    NodeHandler,
    TextHandler,
    $
) {
    "use strict";

    /**
     * @class LinebreakHandler
     * @extends NodeHandler
     */
    return NodeHandler.extend({
        init: function LinebreakHandler(node) {
            this.node = node;
        },

        before: function () {
            return new NodeHandler.EmptyHandler();
        },

        children: function () {
            return new NodeHandler.EmptyHandler();
        },

        after: function () {
            if (!this.node.previousSibling && !this.node.nextSibling && $(this.node).parent().is('td, th')) {
                return TextHandler.createTextHandler(' ');
            } else if (this.node.previousSibling && this.node.previousSibling.tagName === "BR" && $(this.node).parent().is('td, th')) {
                return new TextHandler({
                    // non breaking space preserves table rendering
                    textContent: decodeURI('%C2%A0') + '\n',
                    preformatted: true
                });
            } else {
                return TextHandler.newlineHandler();
            }
        }
    });
});