define("jira/editor/converter/handlers/emphasis-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/factories/whitespace-extractor"
], function (
    NodeHandler,
    TextHandler,
    WhitespaceExtractor
) {
    "use strict";

    /**
     * @class EmphasisHandler
     * @extends NodeHandler
     */
    var handler = NodeHandler.extend({
        init: function EmphasisHandler(node) {
            this.node = node;
        },

        before: function () {
            return TextHandler.createTextHandler('_');
        },

        after: function () {
            return TextHandler.createTextHandler('_');
        }
    });
    return WhitespaceExtractor(handler);
});