define("jira/editor/converter/handler-mapper", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/handlers/heading-handler",
    "jira/editor/converter/handlers/bold-handler",
    "jira/editor/converter/handlers/emphasis-handler",
    "jira/editor/converter/handlers/monospaced-handler",
    "jira/editor/converter/handlers/linebreak-handler",
    "jira/editor/converter/handlers/link-handler",
    "jira/editor/converter/handlers/image-handler",
    "jira/editor/converter/handlers/code-block-handler",
    "jira/editor/converter/handlers/noformat-handler",
    "jira/editor/converter/handlers/list-handler",
    "jira/editor/converter/handlers/list-item-handler",
    "jira/editor/converter/handlers/paragraph-handler",
    "jira/editor/converter/handlers/strikethrough-handler",
    "jira/editor/converter/handlers/superscript-handler",
    "jira/editor/converter/handlers/subscript-handler",
    "jira/editor/converter/handlers/underline-handler",
    "jira/editor/converter/handlers/quote-handler",
    "jira/editor/converter/handlers/panel-handler",
    "jira/editor/converter/handlers/span-handler",
    "jira/editor/converter/handlers/table-handler",
    "jira/editor/converter/handlers/table-row-handler",
    "jira/editor/converter/handlers/table-data-handler",
    "jira/editor/converter/handlers/hr-handler",
    "jira/editor/converter/handlers/cite-handler",
    "jira/editor/wrm"
], function (
    NodeHandler,
    TextHandler,
    HeadingHandler,
    BoldHandler,
    EmphasisHandler,
    MonospacedHandler,
    LinebreakHandler,
    LinkHandler,
    ImageHandler,
    CodeBlockHandler,
    NoformatHandler,
    ListHandler,
    ListItemHandler,
    ParagraphHandler,
    StrikethroughHandler,
    SuperscriptHandler,
    SubscriptHandler,
    UnderlineHandler,
    QuoteHandler,
    PanelHandler,
    SpanHandler,
    TableHandler,
    TableRowHandler,
    TableDataHandler,
    HorizontalLineHandler,
    CiteHandler,
    wrmResources
) {
    "use strict";

    return {
        registerHandlers: function registerHandlers() {
            var ExternalHandler = require("jira/editor/converter/handlers/external-handler");
            wrmResources.getConverters().forEach(ExternalHandler.forConverter);

            NodeHandler.addHandler('pre.external-macro', ExternalHandler.Legacy);

            NodeHandler.addHandler('H1', HeadingHandler);
            NodeHandler.addHandler('H2', HeadingHandler);
            NodeHandler.addHandler('H3', HeadingHandler);
            NodeHandler.addHandler('H4', HeadingHandler);
            NodeHandler.addHandler('H5', HeadingHandler);
            NodeHandler.addHandler('H6', HeadingHandler);
            NodeHandler.addHandler('A', LinkHandler);
            NodeHandler.addHandler('B', BoldHandler);
            NodeHandler.addHandler('STRONG', BoldHandler);
            NodeHandler.addHandler('BR', LinebreakHandler);
            NodeHandler.addHandler('EM', EmphasisHandler);
            NodeHandler.addHandler('I', EmphasisHandler);
            NodeHandler.addHandler('IMG', ImageHandler);
            NodeHandler.addHandler('TT', MonospacedHandler);
            NodeHandler.addHandler('CODE', MonospacedHandler);
            NodeHandler.addHandler('SAMP', MonospacedHandler);
            NodeHandler.addHandler('DIV.preformatted panel', NoformatHandler);
            NodeHandler.addHandler('PRE.noformat panel', NoformatHandler);
            NodeHandler.addHandler('DIV.code panel', CodeBlockHandler);
            NodeHandler.addHandler('PRE.code panel', CodeBlockHandler);
            NodeHandler.addHandler('PANEL-TITLE', NodeHandler.EmptyHandler);
            NodeHandler.addHandler('UL', ListHandler);
            NodeHandler.addHandler('OL', ListHandler);
            NodeHandler.addHandler('LI', ListItemHandler);
            NodeHandler.addHandler('P', ParagraphHandler);
            NodeHandler.addHandler('DEL', StrikethroughHandler);
            NodeHandler.addHandler('SUB', SubscriptHandler);
            NodeHandler.addHandler('SUP', SuperscriptHandler);
            NodeHandler.addHandler('INS', UnderlineHandler);
            NodeHandler.addHandler('U', UnderlineHandler);
            NodeHandler.addHandler('TABLE', TableHandler);
            NodeHandler.addHandler('TR', TableRowHandler);
            NodeHandler.addHandler('CAPTION', TableRowHandler);
            NodeHandler.addHandler('TD', TableDataHandler);
            NodeHandler.addHandler('TH', TableDataHandler);
            NodeHandler.addHandler('SPAN', SpanHandler);
            NodeHandler.addHandler('BLOCKQUOTE', QuoteHandler);
            NodeHandler.addHandler('DIV.panel', PanelHandler);
            NodeHandler.addHandler('PRE.panel', PanelHandler);
            NodeHandler.addHandler('HR', HorizontalLineHandler);
            NodeHandler.addHandler('CITE', CiteHandler);
            NodeHandler.addHandler('#text', TextHandler);
        }
    };
});