/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.editor.configuration;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.plugin.editor.service.RteEnabledService;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

@WebSudoRequired
public class ConfigureRteAction
extends JiraWebActionSupport {
    private static final Logger log = Logger.getLogger(ConfigureRteAction.class);
    private final PageBuilderService pageBuilderService;
    private final HelpUrls helpUrls;
    private final ApplicationProperties applicationProperties;
    private final RteEnabledService rteEnabledService;

    public ConfigureRteAction(@ComponentImport PageBuilderService pageBuilderService, @ComponentImport HelpUrls helpUrls, @ComponentImport ApplicationProperties applicationProperties, RteEnabledService rteEnabledService) {
        this.pageBuilderService = pageBuilderService;
        this.helpUrls = helpUrls;
        this.applicationProperties = applicationProperties;
        this.rteEnabledService = rteEnabledService;
    }

    public String doDefault() throws Exception {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.plugins.jira-editor-plugin:rte-configuration");
        return "input";
    }

    @ActionViewData
    public String getCustomRendering() {
        Stream<ModuleDescriptor<?>> unsupported = this.rteEnabledService.getUnsupportedModules();
        return unsupported.map(descriptor -> {
            String pluginName = Optional.ofNullable(descriptor.getPlugin()).map(Plugin::getName).orElse("Undefined plugin");
            log.warn((Object)String.format("Rich Text Editor does not support rendering component of name \"%s\" provided by plugin \"%s\".", descriptor.getCompleteKey(), pluginName));
            return pluginName;
        }).distinct().collect(Collectors.joining("\n"));
    }

    @ActionViewData
    public boolean getCurrentRteState() {
        return this.applicationProperties.getOption("jira.rte.enabled");
    }

    @ActionViewData
    public ViewHelpUrl getHelpUrl() {
        return new ViewHelpUrl(this.helpUrls.getUrl("rte.configuration"));
    }

    @ActionViewData
    public ViewHelpUrl getRenderersHelpUrl() {
        return new ViewHelpUrl(this.helpUrls.getUrl("configrenderers"));
    }

    @ActionViewData
    public String getRteSwitchApKey() {
        return "jira.rte.enabled";
    }

    public static class ViewHelpUrl {
        private final String url;
        private final String title;

        public ViewHelpUrl(HelpUrl url) {
            this.url = url.getUrl();
            this.title = url.getTitle();
        }

        public String getUrl() {
            return this.url;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

