/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.editor;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.editor.service.Converter;
import com.atlassian.jira.plugin.editor.service.RteEnabledService;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.log4j.Logger;

public class RteDataProvider
implements WebResourceDataProvider {
    private static final Logger log = Logger.getLogger(RteDataProvider.class);
    private static final String CONTEXT_NAME = "jira.rich.editor.content";
    private final ApplicationProperties applicationProperties;
    private final WebResourceAssemblerFactory resourceAssemblerFactory;
    private final RteEnabledService rteEnabledService;

    public RteDataProvider(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport WebResourceAssemblerFactory resourceAssemblerFactory, RteEnabledService rteEnabledService) {
        this.applicationProperties = applicationProperties;
        this.resourceAssemblerFactory = resourceAssemblerFactory;
        this.rteEnabledService = rteEnabledService;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                JSONObject map = new JSONObject();
                try {
                    map.put("allowedAttachments", RteDataProvider.this.applicationProperties.getOption("jira.option.allowattachments"));
                    map.put("resources", (Object)RteDataProvider.this.getWebResources());
                    map.put("converters", (Collection)RteDataProvider.this.rteEnabledService.getConverters().stream().map(Converter::asJSON).collect(CollectorsUtil.toImmutableList()));
                    map.write(writer);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private List<String> getWebResources() {
        WebResourceAssembler assembler = this.resourceAssemblerFactory.create().build();
        assembler.resources().exclude(null, (Set)ImmutableSet.of((Object)"_super"));
        assembler.resources().requireContext(CONTEXT_NAME);
        assembler.resources().requireContext("jira.global.look-and-feel");
        return (List)StreamSupport.stream(assembler.assembled().drainIncludedResources().getResources().spliterator(), false).map(this::mapWebResource).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableList());
    }

    private String mapWebResource(WebResource webResource) {
        if (webResource instanceof PluginCssResource) {
            PluginCssResource cssResource = (PluginCssResource)webResource;
            return cssResource.getStaticUrl(UrlMode.RELATIVE);
        }
        log.warn((Object)String.format("\"%s\" context supports only CSS resources, please review atlassian-plugin.xml, some <resource> or <dependency> is including different resource type.", CONTEXT_NAME));
        return null;
    }
}

