/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.jira.screenshot.webwork;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.SecureUserTokenManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.util.UtilDateTime;
import webwork.action.ActionContext;
import webwork.config.Configuration;

public class ShowAttachScreenshotFormAction
extends AbstractCommentableIssue {
    private static final String SCREENSHOT_PREFIX = "screenshot-";
    private static final Pattern SHOT_NUMBER_REGEX = Pattern.compile("screenshot-(\\d+)");
    private static final String HEADER_USER_AGENT = "user-agent";
    private static final String MAC_OS_IDENTIFIER = "Mac";
    private static final String PLATFORM_MAC = "mac";
    private static final String PLATFORM_PC = "pc";
    private long maxSize = Long.MIN_VALUE;
    private final AttachmentService attachmentService;
    private final TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator;
    private final IssueUpdater issueUpdater;
    private final SecureUserTokenManager secureUserTokenManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SecureTokenGenerator secureTokenGenerator = DefaultSecureTokenGenerator.getInstance();
    private String[] filetoconvert;
    private static final String FILETOCONVERT = "filetoconvert";
    private String attachScreenshotFilename;
    private String secureToken;
    private String formToken;

    public ShowAttachScreenshotFormAction(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil, AttachmentService attachmentService, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator, IssueUpdater issueUpdater, SecureUserTokenManager secureUserTokenManager, JiraAuthenticationContext jiraAuthenticationContext) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.attachmentService = attachmentService;
        this.temporaryAttachmentsMonitorLocator = temporaryAttachmentsMonitorLocator;
        this.issueUpdater = issueUpdater;
        this.secureUserTokenManager = secureUserTokenManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public String doDefault() throws Exception {
        if (this.getFormToken() == null) {
            this.setFormToken(this.secureTokenGenerator.generateToken());
        }
        try {
            this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), this.getIssueObject());
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return "input";
    }

    public String getNextScreenshotName() {
        return SCREENSHOT_PREFIX + this.getNextScreenshotNumber();
    }

    public String getNewUserToken() {
        return this.secureUserTokenManager.generateToken(this.getLoggedInUser(), SecureUserTokenManager.TokenType.SCREENSHOT);
    }

    public String getUserPlatform() {
        HttpServletRequest request = ActionContext.getRequest();
        String userAgent = request.getHeader(HEADER_USER_AGENT);
        if (StringUtils.contains((String)userAgent, (String)MAC_OS_IDENTIFIER)) {
            return PLATFORM_MAC;
        }
        return PLATFORM_PC;
    }

    public int getNextScreenshotNumber() {
        int last = 0;
        for (Attachment attachment : this.getIssueObject().getAttachments()) {
            Matcher matcher = SHOT_NUMBER_REGEX.matcher(attachment.getFilename());
            if (!matcher.find()) continue;
            try {
                last = Math.max(last, Integer.parseInt(matcher.group(1)));
            }
            catch (RuntimeException impossible) {
                this.log.info((Object)("problem parsing screenshot number in " + attachment.getFilename()), (Throwable)impossible);
            }
        }
        return last + 1;
    }

    public long getMaxSize() {
        if (this.maxSize != Long.MIN_VALUE) {
            return this.maxSize;
        }
        try {
            this.maxSize = Long.parseLong(Configuration.getString((String)"webwork.multipart.maxSize"));
        }
        catch (NumberFormatException e) {
            this.maxSize = -1L;
        }
        return this.maxSize;
    }

    public String[] getFiletoconvert() {
        return this.filetoconvert;
    }

    public void setFiletoconvert(String[] filetoconvert) {
        this.filetoconvert = filetoconvert;
    }

    public String getAttachscreenshotname() {
        return this.attachScreenshotFilename;
    }

    public void setAttachscreenshotname(String attachScreenshotFilename) {
        this.attachScreenshotFilename = attachScreenshotFilename;
    }

    public String getSecureToken() {
        return this.secureToken;
    }

    public void setSecureToken(String secureToken) {
        this.secureToken = secureToken;
    }

    public String getFormToken() {
        return this.formToken;
    }

    public void setFormToken(String formToken) {
        this.formToken = formToken;
    }

    protected void doValidation() {
        try {
            if (this.secureToken != null) {
                this.jiraAuthenticationContext.setLoggedInUser(this.secureUserTokenManager.useToken(this.secureToken, SecureUserTokenManager.TokenType.SCREENSHOT));
            }
            this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), this.getIssueObject());
            super.doValidation();
        }
        catch (IssueNotFoundException ex) {
            return;
        }
        catch (IssuePermissionException ex) {
            return;
        }
    }

    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }

    private void clearTemporaryAttachmentsForIssue() throws GenericEntityException {
        this.temporaryAttachmentsMonitorLocator.get(true).clearEntriesForIssue(this.getId());
    }

    private List<Long> getTemporaryFileIdsToConvert() {
        String[] strings = this.getFiletoconvert();
        if (strings == null) {
            return Collections.emptyList();
        }
        List<String> fileIdStrings = Arrays.asList(strings);
        return CollectionUtil.transform(fileIdStrings, input -> Long.parseLong(input));
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Issue issue = this.getIssueObject();
        ArrayList<ChangeItemBean> changeItemBeans = new ArrayList<ChangeItemBean>();
        List<Long> fileIdsToConvert = this.getTemporaryFileIdsToConvert();
        try {
            TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(false);
            if (temporaryAttachmentsMonitor == null) {
                this.addError(FILETOCONVERT, this.getText("attachment.temporary.session.time.out"));
                return "error";
            }
            String fileNameWithExt = this.getWithExtenstion(this.attachScreenshotFilename);
            changeItemBeans.addAll(this.convertTemporaryAttachments(this.getLoggedInUser(), this.getIssueObject(), fileIdsToConvert, temporaryAttachmentsMonitor, fileNameWithExt));
        }
        catch (AttachmentException e) {
            this.addError(FILETOCONVERT, e.getMessage());
            return "error";
        }
        this.clearTemporaryAttachmentsForIssue();
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(this.getIssue(), this.getIssue(), EventType.ISSUE_UPDATED_ID, this.getLoggedInUser());
        issueUpdateBean.setComment(this.createComment());
        issueUpdateBean.setChangeItems(changeItemBeans);
        issueUpdateBean.setDispatchEvent(true);
        issueUpdateBean.setParams(EasyMap.build((Object)"eventsource", (Object)"action"));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/browse/" + issue.getKey());
    }

    private String getWithExtenstion(String fileName) {
        if (StringUtils.endsWithIgnoreCase((String)fileName, (String)".png")) {
            return fileName;
        }
        return fileName + ".png";
    }

    private List<ChangeItemBean> convertTemporaryAttachments(ApplicationUser user, Issue issue, List<Long> selectedAttachments, TemporaryAttachmentsMonitor temporaryAttachmentsMonitor, String attachScreenshotFileName) throws AttachmentException {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"attachScreenshotFileName", (Object)attachScreenshotFileName);
        Assertions.notNull((String)"selectedAttachments", selectedAttachments);
        Assertions.notNull((String)"temporaryAttachmentsMonitor", (Object)temporaryAttachmentsMonitor);
        ArrayList<ChangeItemBean> ret = new ArrayList<ChangeItemBean>();
        for (Long selectedAttachment : selectedAttachments) {
            TemporaryAttachment tempAttachment = temporaryAttachmentsMonitor.getById(selectedAttachment);
            ChangeItemBean cib = this.attachmentManager.createAttachment(tempAttachment.getFile(), attachScreenshotFileName, tempAttachment.getContentType(), user, issue, Collections.emptyMap(), (Date)UtilDateTime.nowTimestamp());
            if (cib == null) continue;
            ret.add(cib);
        }
        temporaryAttachmentsMonitor.clearEntriesForFormToken(this.formToken);
        return ret;
    }
}

