Backbone.define('JIRA.DevStatus.PullRequestView', JIRA.DevStatus.BaseSummaryView.extend({

    template: JIRA.Templates.DevStatus.PullRequest.summaryPanel,

    _onSummaryLinkClick: function(e) {
        e.preventDefault();

        this.detailDialogPullRequestView = new JIRA.DevStatus.DetailDialogPullRequestView(
            _.extend(this.getDefaultDetailDialogParameters(), {
                id: "devstatus-pullrequest-detail-dialog",
                count: this.model.getOverall().count,
                reviewersThreshold: 2
            }));
        JIRA.DevStatus.PullRequestsAnalytics.fireSummaryClickedEvent(this.options.analyticsModel.getSummary());
        this.detailDialogPullRequestView.show();
    }
}));
