AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-build-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks");

(function() {

    module("JIRA.DevStatus.BuildView", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            //Tests will attempt to make an ajax call to JIRA which will redirect to the login page
            //This will stop that from happening.
            this.server = sinon.fakeServer.create();
            this.fixture = jQuery("#qunit-fixture");
            this.statusPanel = jQuery('<div></div>').appendTo(this.fixture);
            JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Builds", this.sandbox);

            this.livestamp = jQuery.fn.livestamp;
            jQuery.fn.livestamp = sinon.spy();
        },
        teardown : function () {
            this.sandbox.restore();
            this.server.restore();
            // close dialogs
            JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();
            //JIRA form dialog appends overflow: hidden to the body of the page. This is to remove it.
            AJS.$("body").css("overflow", "initial");

            jQuery.fn.livestamp = this.livestamp;
        },
        createView: function(data) {
            var model = new JIRA.DevStatus.MockSummaryModel();
            model.getOverall.returns(data);
            var analyticsModel = {
                getIssue: sinon.stub(),
                getSummary: sinon.stub().returns({unicorn: "awesome"})
            };
            this.view = new JIRA.DevStatus.BuildView({
                model: model,
                el: this.statusPanel,
                livestampRelativizeThreshold: 3600,
                analyticsModel: analyticsModel
            });
        }
    });

    test("not show panel", function() {
        this.createView({count: 0});
        this.view.render();
        ok(!this.statusPanel.html(), "content is not rendered");
        ok(this.statusPanel.hasClass("hidden"), "panel is hidden");

        this.statusPanel.find(".summary-build").click();
        ok(!_.isObject(this.view.detailDialogBuildView), "DetailDialogBuildView is not created when link doesn't exist");
    });

    test("render and show panel", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 1, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 0, successfulBuildCount: 1, unknownBuildCount: 0});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");

        this.statusPanel.find(".summary").click();
        ok(_.isObject(this.view.detailDialogBuildView), "DetailDialogBuildView is created when the link is clicked");
    });

    test("render and show panel - one successful", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 1, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 0, successfulBuildCount: 1, unknownBuildCount: 0});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "1", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "1 build", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-approve"), "success icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - all successful", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 5, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 0, successfulBuildCount: 5, unknownBuildCount: 0});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "5", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "5 builds", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-approve"), "success icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - successful and failed", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 5, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 2, successfulBuildCount: 3, unknownBuildCount: 0});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "2", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "2 builds failing", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-error"), "failure icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - successful and unknown", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 5, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 0, successfulBuildCount: 3, unknownBuildCount: 2});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "3", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "3 builds", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-error"), "failure icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - successful, unknown, failed", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 6, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 1, successfulBuildCount: 3, unknownBuildCount: 2});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "1", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "1 build failing", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-error"), "failure icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - one failed", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 1, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 1, successfulBuildCount: 0, unknownBuildCount: 0});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "1", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "1 build failing", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-error"), "failure icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - all failed", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 5, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 5, successfulBuildCount: 0, unknownBuildCount: 0});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "5", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "5 builds failing", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-error"), "failure icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - failed and unknown", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 5, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 3, successfulBuildCount: 0, unknownBuildCount: 2});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "3", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "3 builds failing", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-error"), "failure icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - one unknown", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 1, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 0, successfulBuildCount: 0, unknownBuildCount: 1});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "1", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "1 build incomplete", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-devtools-task-cancelled"), "unknown icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("render and show panel - all unknown", function() {
        JIRA.DevStatus.Date.format = 'YYYY-MM-DD';
        this.createView({count: 5, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 0, successfulBuildCount: 0, unknownBuildCount: 5});
        this.view.render();

        ok(this.statusPanel.html(), "content is rendered");
        ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");
        equal(this.statusPanel.find(".count").text(), "5", "summary count is correct");
        equal(this.statusPanel.find(".summary").text(), "5 builds incomplete", "summary message is correct");
        ok(this.statusPanel.has(".aui-iconfont-devtools-task-cancelled"), "unknown icon is shown");
        equal(this.statusPanel.find("time.livestamp").attr("title"), "2010-01-01", "timestamp is correct");
    });

    test("event is sent when the summary link is clicked", function() {
        this.createView({count: 5, lastUpdated: '2010-01-01T12:34:56.000+0100', failedBuildCount: 0});
        this.view.render();

        this.statusPanel.find(".summary").click();
        equal(JIRA.DevStatus.BuildsAnalytics.fireSummaryClickedEvent.callCount, 1);
        ok(JIRA.DevStatus.BuildsAnalytics.fireSummaryClickedEvent.getCall(0).calledWith({unicorn: "awesome"}));
        JIRA.DevStatus.BuildsAnalytics.fireSummaryClickedEvent.reset();
    });

})();
