AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-branch-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks");

(function() {
    module("JIRA.DevStatus.BranchView", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            //Tests will attempt to make an ajax call to JIRA which will redirect to the login page
            //This will stop that from happening.
            this.server = sinon.fakeServer.create();
            this.fixture = jQuery("#qunit-fixture");
            this.statusPanel = jQuery('<div></div>').appendTo(this.fixture)
            JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Branches", this.sandbox);
        },
        teardown : function () {
            this.sandbox.restore();
            this.server.restore();
            //JIRA form dialog appends overflow: hidden to the body of the page. This is to remove it.
            AJS.$("body").css("overflow", "initial");
        },
        createView: function(data) {
            var model = new JIRA.DevStatus.MockSummaryModel();
            var analyticsModel = {
                getIssue: sinon.stub(),
                getSummary: sinon.stub().returns({rainbow: "haha"})
            };

            model.getOverall.returns(data);
            this.view = new JIRA.DevStatus.BranchView({
                model: model,
                el: this.statusPanel,
                livestampRelativizeThreshold: 3600,
                analyticsModel: analyticsModel
            });
        },
        assertView: function() {
            this.view.render();
            ok(this.statusPanel.html(), "content is rendered");
            ok(!this.statusPanel.hasClass("hidden"), "panel is not hidden");

            this.statusPanel.find(".summary").click();
            ok(_.isObject(this.view.detailDialogBranchView), "DetailDialogBranchView is created when the link is clicked");

            equal(JIRA.DevStatus.BranchesAnalytics.fireSummaryClickedEvent.callCount, 1);
            ok(JIRA.DevStatus.BranchesAnalytics.fireSummaryClickedEvent.getCall(0).calledWith({rainbow: "haha"}));
        }
    });

    test("render and show panel single", function() {
        this.createView({count: 1});
        this.assertView();
        equal(this.statusPanel.find('.count').text(), '1');
        equal(this.statusPanel.find('.summary').text(), '1 branch');
    });

    test("render and show panel multiple", function() {
        this.createView({count: 2});
        this.assertView();
        equal(this.statusPanel.find('.count').text(), '2');
        equal(this.statusPanel.find('.summary').text(), '2 branches');
    });

    test("analytics data from the dev status module is correctly passed to the detail dialog", function() {
        this.createView({count: 2});
        var data = {
            isAssignee: true,
            isAssignable: false,
            issueStatus: "angry",
            issueType: "pokemon"
        };

        this.view.options.analyticsModel.getIssue.returns(data);
        this.assertView();
        deepEqual(this.view.detailDialogBranchView.analyticIssueData, data);
    });
})();
