/**
 * @class JIRA.DevStatus.SummaryErrorView
 */
Backbone.define('JIRA.DevStatus.SummaryErrorView', JIRA.DevStatus.BaseSummaryView.extend({
    /**
     * @constructs
     * @extends JIRA.DevStatus.BaseSummaryView
     * @param {object} options
     * @param {boolean} [options.showContactAdminForm] whether to show "contact admin" link
     */
    initialize: function (options) {
        this.showContactAdminForm = options.showContactAdminForm;
    },

    /**
     * @returns {JIRA.DevStatus.SummaryErrorView}
     */
    render: function() {
        if (this.isVisible()) {
            this.$el.html(JIRA.Templates.DevStatus.connectionProblemAsInfoWithoutIcon({
                instances: this.model.get("errorInstances"),
                notConfiguredInstances: this.model.get("configInstances"),
                showContactAdminForm: this.showContactAdminForm
            }));
            this.show();
        } else {
            // if no errors, hide this view
            this.hide();
        }

        return this;
    },

    isVisible: function() {
        return this.model.get("hasErrors");
    }
}));
