AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks");(function(){var a="Learn about this issue or go to application links to fix it.";module("JIRA.DevStatus.SummaryErrorView",{setup:function(){this.sandbox=sinon.sandbox.create();this.fixture=jQuery("#qunit-fixture");this.createPanel()},teardown:function(){this.sandbox.restore()},createPanel:function(){this.panel=jQuery('<div class="message-panel hidden">').appendTo(this.fixture)},createMockModel:function(e){e=e||{};var f=e.errorInstances||[];var d=e.configInstances||[];var c=_.isUndefined(e.hasErrors)?!(_.isEmpty(f)&&_.isEmpty(d)):e.hasErrors;var b=new JIRA.DevStatus.MockSummaryModel();b.get.withArgs("hasErrors").returns(c);b.get.withArgs("errorInstances").returns(f);b.get.withArgs("configInstances").returns(d);return b},createInstances:function(b){return _.map(_.range(1,b+1),function(c){return{name:"inst_"+c,baseUrl:"#"+c}})},assertGenericMsg:function(c){var b=this.panel.html().indexOf("JIRA is having difficulty contacting the applications that supply development status information");ok(c?b>=0:b<0,"generic error msg is "+(c?"":"not ")+"shown")},assertAndGetGenericMsgIndex:function(){var b="JIRA is having difficulty contacting ";var c=this.panel.html().indexOf(b);ok(c>=0,"instance error msg is shown");return c+b.length+1},assertOccur:function(b,e,d,c){ok(b.indexOf(e,d)>=0,c)},assertOccurBefore:function(d,h,e,g,f){var c=d.indexOf(h,g);var b=d.indexOf(e,g);ok(c>=0&&c<b,f)},assertOccurAfter:function(d,h,b,g,f){var e=d.indexOf(b,g);var c=d.indexOf(h,e);ok(c>=0&&e>=0,f)},assertOccurBetween:function(f,j,b,c,i,d){var g=f.indexOf(b,i);var h=f.indexOf(j,g+b.length);var e=f.indexOf(c,g+b.length);ok(g>=0&&h>=0&&e>=0&&h>g&&h<e,d)},assertNotOccurBetween:function(f,j,b,c,i,d){var g=f.indexOf(b,i);var h=f.indexOf(j,g+b.length);var e=f.indexOf(c,g+b.length);ok(h<0||(h>=0&&g>=0&&e>=0&&(h<g||h>e)),d)},getConfigErrors:function(){var b=this.panel.find(".config-errors:visible");return{description:b.find(".description"),hints:b.find(".hints"),findLink:function(c){return b.find(AJS.format("span[data-name={0}] a",c))}}}});test("don't show panel when no errors",function(){var c=this.createMockModel();var b=new JIRA.DevStatus.SummaryErrorView({model:c,el:this.panel});b.render();ok(this.panel.hasClass("hidden"),"panel is hidden");ok(!this.panel.html(),"content is not rendered")});test("show panel when errors without instances",function(){var c=this.createMockModel({hasErrors:true});var b=new JIRA.DevStatus.SummaryErrorView({model:c,el:this.panel});b.render();ok(!this.panel.hasClass("hidden"),"panel is not hidden");ok(this.panel.html(),"content is rendered");this.assertGenericMsg(true)});test("show panel when errors with 1 instance",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"}]});var c=new JIRA.DevStatus.SummaryErrorView({model:e,el:this.panel});c.render();ok(!this.panel.hasClass("hidden"),"panel is not hidden");ok(this.panel.html(),"content is rendered");this.assertGenericMsg(false);var d=this.assertAndGetGenericMsgIndex();var b=this.panel.html();this.assertOccur(b,"instance 1",d,"instance 1 is shown")});test("show panel when errors with 2 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"}]});var c=new JIRA.DevStatus.SummaryErrorView({model:e,el:this.panel});c.render();ok(!this.panel.hasClass("hidden"),"panel is not hidden");ok(this.panel.html(),"content is rendered");this.assertGenericMsg(false);var d=this.assertAndGetGenericMsgIndex();var b=this.panel.html();this.assertOccurBefore(b,"instance 1","instance 2",d,"instance 1 is shown before instance 2");this.assertOccurBetween(b,"> and ","instance 1","instance 2",d,"'1 and 2' is shown");this.assertNotOccurBetween(b,">, and ","instance 1","instance 2",d,"'1, and 2' is not shown");this.assertOccurAfter(b,"instance 2","instance 1",d,"instance 2 is shown")});test("show panel when errors with 3 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"},{name:"instance 3",baseUrl:"#"}]});var c=new JIRA.DevStatus.SummaryErrorView({model:e,el:this.panel});c.render();ok(!this.panel.hasClass("hidden"),"panel is not hidden");ok(this.panel.html(),"content is rendered");this.assertGenericMsg(false);var d=this.assertAndGetGenericMsgIndex();var b=this.panel.html();this.assertOccurBefore(b,"instance 1","instance 2",d,"instance 1 is shown before instance 2");this.assertOccurBetween(b,">, ","instance 1","instance 2",d,"'1, 2' is shown");this.assertNotOccurBetween(b,"> and ","instance 1","instance 2",d,"'1 and 2' is not shown");this.assertNotOccurBetween(b,">, and ","instance 1","instance 2",d,"'1, and 2' is not shown");this.assertOccurBetween(b,"instance 2","instance 1","instance 3",d,"instance 2 is shown");this.assertOccurBetween(b,">, and ","instance 2","instance 3",d,"'2, and 3' is shown");this.assertNotOccurBetween(b,"> and ","instance 1","instance 2",d,"'2 and 3' is not shown");this.assertOccurAfter(b,"instance 3","instance 2",d,"instance 3 is shown")});test("show panel when errors with 4 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"},{name:"instance 3",baseUrl:"#"},{name:"instance 4",baseUrl:"#"}]});var c=new JIRA.DevStatus.SummaryErrorView({model:e,el:this.panel});c.render();ok(!this.panel.hasClass("hidden"),"panel is not hidden");ok(this.panel.html(),"content is rendered");this.assertGenericMsg(false);var d=this.assertAndGetGenericMsgIndex();var b=this.panel.html();this.assertOccurBefore(b,"instance 1","instance 2",d,"instance 1 is shown before instance 2");this.assertOccurBetween(b,">, ","instance 1","instance 2",d,"'1, 2' is shown");this.assertNotOccurBetween(b,"> and ","instance 1","instance 2",d,"'1 and 2' is not shown");this.assertNotOccurBetween(b,">, and ","instance 1","instance 2",d,"'1, and 2' is not shown");this.assertOccurBetween(b,"instance 2","instance 1","instance 3",d,"instance 2 is shown");this.assertOccurBetween(b,">, ","instance 2","instance 3",d,"'2, 3' is shown");this.assertNotOccurBetween(b,"> and ","instance 1","instance 2",d,"'2 and 3' is not shown");this.assertNotOccurBetween(b,">, and ","instance 1","instance 2",d,"'2, and 3' is not shown");this.assertOccurBetween(b,"instance 3","instance 2","another application",d,"instance 3 is shown");this.assertOccurAfter(b,"and another application","instance 3",d,"'and another instance' is shown")});test("show panel when errors with 5 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"},{name:"instance 3",baseUrl:"#"},{name:"instance 4",baseUrl:"#"},{name:"instance 5",baseUrl:"#"}]});var c=new JIRA.DevStatus.SummaryErrorView({model:e,el:this.panel});c.render();ok(!this.panel.hasClass("hidden"),"panel is not hidden");ok(this.panel.html(),"content is rendered");this.assertGenericMsg(false);var d=this.assertAndGetGenericMsgIndex();var b=this.panel.html();this.assertOccurBefore(b,"instance 1","instance 2",d,"instance 1 is shown before instance 2");this.assertOccurBetween(b,">, ","instance 1","instance 2",d,"'1, 2' is shown");this.assertNotOccurBetween(b,"> and ","instance 1","instance 2",d,"'1 and 2' is not shown");this.assertNotOccurBetween(b,">, and ","instance 1","instance 2",d,"'1, and 2' is not shown");this.assertOccurBetween(b,"instance 2","instance 1","instance 3",d,"instance 2 is shown");this.assertOccurBetween(b,">, ","instance 2","instance 3",d,"'2, 3' is shown");this.assertNotOccurBetween(b,"> and ","instance 1","instance 2",d,"'2 and 3' is not shown");this.assertNotOccurBetween(b,">, and ","instance 1","instance 2",d,"'2, and 3' is not shown");this.assertOccurBetween(b,"instance 3","instance 2"," and 2 more applications",d,"instance 3 is shown");this.assertOccurAfter(b,"and 2 more applications","instance 3",d,"'and 2 more applications' is shown")});test("show configuration error for 1 instance",function(){var c=new JIRA.DevStatus.SummaryErrorView({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(1)})}).render();var b=this.getConfigErrors();equal(b.description.text(),"Couldn't read data from inst_1.","config error shown for inst_1");equal(b.hints.text(),a,"config hints shown")});test("show configuration error for 2 instances",function(){var c=new JIRA.DevStatus.SummaryErrorView({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(2)})}).render();var b=this.getConfigErrors();equal(b.description.text(),"Couldn't read data from inst_1 and inst_2.","config error shown for inst_1+inst_2");equal(b.hints.text(),a,"config hints shown")});test("show configuration error for 3 instances",function(){var c=new JIRA.DevStatus.SummaryErrorView({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(3)})}).render();var b=this.getConfigErrors();equal(b.description.text(),"Couldn't read data from inst_1, inst_2, and inst_3.","config error shown for inst_1+inst_2+inst_3");equal(b.hints.text(),a,"config hints shown")});test("show configuration error for 4 instances",function(){var c=new JIRA.DevStatus.SummaryErrorView({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(4)})}).render();var b=this.getConfigErrors();equal(b.description.text(),"Couldn't read data from inst_1, inst_2, inst_3, and 1 other application.","config error shown for inst_1+inst_2+inst_3+1 more");equal(b.hints.text(),a,"config hints shown")});test("show configuration error for 5 instances",function(){var c=new JIRA.DevStatus.SummaryErrorView({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(5)})}).render();var b=this.getConfigErrors();equal(b.description.text(),"Couldn't read data from inst_1, inst_2, inst_3, and 2 other applications.","config error shown for inst_1+inst_2+inst_3+2 more");equal(b.hints.text(),a,"config hints shown")});test("configuration error links are correct",function(){var d=this.createInstances(4);var c=new JIRA.DevStatus.SummaryErrorView({el:this.panel,model:this.createMockModel({configInstances:d})}).render();var b=this.getConfigErrors();var e=d.slice(0,3);_.each(e,function(i){var f=i.name;var h=i.baseUrl;var g=b.findLink(f);deepEqual({href:g.attr("href"),text:g.text()},{href:h,text:f},AJS.format("{0} links to {1}",i.name,h))})});test("show both connection and configuration errors",function(){var b=new JIRA.DevStatus.SummaryErrorView({el:this.panel,model:this.createMockModel({errorInstances:[{name:"inst_1",baseUrl:"#1"}],configInstances:[{name:"inst_2",baseUrl:"#2"}]})}).render();equal(this.getConfigErrors().description.text(),"Couldn't read data from inst_2.","config error is shown");this.assertOccur(this.panel.text(),"JIRA is having difficulty contacting inst_1","connection error is also shown")})})();