AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks");

module("JIRA.DevStatus.BaseSummaryView", {
    setup: function() {
        this.sandbox = sinon.sandbox.create();
        this.fixture = jQuery("#qunit-fixture");
        this.statusPanel = jQuery('<div></div>').appendTo(this.fixture)
        this.model = new JIRA.DevStatus.MockSummaryModel();
    },

    /**
     * Checks that the given model's "on" method has been called.
     *
     * @param {Backbone.View} view
     * @param {string} eventName
     * @param {Backbone.Model} model
     * @param {Function} assertions callback to perform assertions on a matching call
     */
    viewListensTo: function(view, model, eventName, assertions) {
        for (var i = 0; i < model.on.callCount; i++) {
            var call = model.on.getCall(i);

            // make sure the callback does its thing
            if (call.args[0] === eventName) {
                ok(true, "view should listen to " + eventName);
                assertions.call(this, call);

                ok(call.args[2] === view, "3rd args to Backbone.View.on should be the view's 'this'");
                return;
            }
        }

        ok(false, "view should listen to " + eventName);
    },

    teardown: function() {
        this.sandbox.restore();
    }
});

test("view listens to hasData change event", function() {
    this.model.get.withArgs('hasData').returns(true);

    var view = new JIRA.DevStatus.BaseSummaryView({
        model: this.model,
        el: this.statusPanel,
        livestampRelativizeThreshold: 3600
    });

    this.viewListensTo(view, this.model, "change:hasData", function(call) {
        // trigger the change event and check the class was updated
        call.args[1].call(view);
        ok(this.statusPanel.hasClass('js-has-data'), "view should set 'js-has-data' class on its element");
    });
});

test("view listens to dataLoading change event", function() {
    this.model.get.withArgs('dataLoading').returns(true);

    var view = new JIRA.DevStatus.BaseSummaryView({
        model: this.model,
        el: this.statusPanel,
        livestampRelativizeThreshold: 3600
    });

    this.viewListensTo(view, this.model, "change:dataLoading", function(call) {
        // trigger the change event and check the class was updated
        call.args[1].call(view);
        ok(this.statusPanel.hasClass('data-loading'), "view should set 'data-loading' class on its element");

    });
});

test("Test correct navigable summary link url", function() {
    expect(4);

    this.sandbox.stub(JIRA.DevStatus.Navigate, 'getUrl');
    this.model.getType.returns("charmander");
    var view = new JIRA.DevStatus.BaseSummaryView({
        model: this.model,
        el: this.statusPanel,
        livestampRelativizeThreshold: 3600
    });

    this.statusPanel.append('<a class="summary"></a>');
    var instance = this;
    function assertAndReset(url, expected) {
        JIRA.DevStatus.Navigate.getUrl.returns(url);
        view._renderNavigableSummaryLink();
        equal(instance.statusPanel.find(".summary").attr("href"), expected);
    }

    var testCases = [
        ["/browse/XSS-1", "/browse/XSS-1?devStatusDetailDialog=charmander"],
        ["/browseeee/POKEMON-9001?devStatusDetailDialog=xxx&param1=value1", "/browseeee/POKEMON-9001?devStatusDetailDialog=charmander&param1=value1"],
        ["http://localhost:2990/jira/i#browse/DEV-2?jql=project%2520%253D%2520DEV&devStatusDetailDialog=create-branch", "http://localhost:2990/jira/browse/DEV-2?jql=project%2520%253D%2520DEV&devStatusDetailDialog=charmander"],
        ["https://jdog.jira-dev.com/browse/JDEV-24823?jql=project%20in%20(FUSE%2C%20JDEV)%20AND%20status%20%3D%20%22In%20Progress%22&devStatusDetailDialog=pikachu&wut=doge&anime=pokemon",
         "https://jdog.jira-dev.com/browse/JDEV-24823?jql=project%20in%20(FUSE%2C%20JDEV)%20AND%20status%20%3D%20%22In%20Progress%22&devStatusDetailDialog=charmander&wut=doge&anime=pokemon"]
    ];
    _.each(testCases, function(testCase) {
        assertAndReset(testCase[0], testCase[1]);
    });
});
