AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");

module("JIRA.DevStatus.Labs.LabOptInModel", {
    setup: function() {
        this.fixture = jQuery("#qunit-fixture");
        this.devStatusContainer = jQuery('<div id="devstatus-container"></div>').appendTo(this.fixture);

        this.sandbox = sinon.sandbox.create();
        this.server = sinon.fakeServer.create();

        JIRA.DevStatus.LabsAnalytics = JIRA.DevStatus.LabsAnalytics || {};
        JIRA.DevStatus.LabsAnalytics.fireLabsEvent = this.sandbox.stub();
    },

    teardown: function() {
        this.sandbox.restore();
        this.server.restore();
    }
});

test("createFromDOM reads model state from DOM", function() {
    var isLabsAllowed = true;
    var isLabsOptedIn = true;
    this.devStatusContainer.attr('data-labs-json', JSON.stringify({ allowed: isLabsAllowed, optedIn: isLabsOptedIn}) );

    var labsOptIn = JIRA.DevStatus.Labs.LabsOptInModel.createFromDOM(this.fixture);
    equal(labsOptIn.isAllowed(), isLabsAllowed);
    equal(labsOptIn.isOptedIn(), isLabsOptedIn);
});

test("setOptedIn calls the REST resource", function() {
    var labsOptIn = new JIRA.DevStatus.Labs.LabsOptInModel({
        allowed: true,
        dismissed: false,
        optedIn: false
    });

    var jqXHR = labsOptIn.toggleOptedIn();
    equal(jqXHR.isResolved(), false, "jqXHR should not be resolved until AJAX response comes back");
    equal(this.server.requests.length, 1, "the REST resource was called");

    AJS.TestContractManager.respondToRequest("labsOptIn-labsOptInTrue", this.server.requests[0]);
    equal(jqXHR.isResolved(), true, "jqXHR should be resolved once AJAX response comes back");
});

test("setOptedIn fires analytics", function() {
    var labsOptIn = new JIRA.DevStatus.Labs.LabsOptInModel({
        allowed: true,
        optedIn: false
    });

    labsOptIn.toggleOptedIn();
    this.server.requests[0].respond(204);

    ok(JIRA.DevStatus.LabsAnalytics.fireLabsEvent.called, "fireLabsEvent should be called");
    equal(JIRA.DevStatus.LabsAnalytics.fireLabsEvent.getCall(0).args[0], true, "fireLabsEvent should be called with toggle=true");
});

test("toggleOptedIn calls setOptedIn", function() {
    var labsOptIn = new JIRA.DevStatus.Labs.LabsOptInModel({
        allowed: true,
        optedIn: true
    });

    labsOptIn.setOptedIn = sinon.stub();
    labsOptIn.setOptedIn.returns(new jQuery.Deferred().resolve());

    labsOptIn.toggleOptedIn();

    // expect setOptedIn(false) was called once
    ok(labsOptIn.setOptedIn.called, "setOptedIn is called");
    equal(labsOptIn.setOptedIn.getCall(0).args[0], false, "optedIn should be set to false");
});

test("setDismissed calls the REST resource", function() {
    var labsOptIn = new JIRA.DevStatus.Labs.LabsOptInModel({
        allowed: true,
        dismissed: true,
        optedIn: false
    });

    var jqXHR = labsOptIn.setDismissed(false);
    equal(jqXHR.isResolved(), false, "jqXHR should not be resolved until AJAX response comes back");
    equal(this.server.requests.length, 1, "the REST resource was called");

    AJS.TestContractManager.respondToRequest("labsOptIn-labsInfoDismissedFalse", this.server.requests[0]);
    equal(jqXHR.isResolved(), true, "jqXHR should be resolved once AJAX response comes back");
});
