AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-build-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");module("JIRA.DevStatus.DetailDialogBuildView",{setup:function(){this.sandbox=sinon.sandbox.create();this.issueKey="DEV-1";this.issueId=10000;this.server=sinon.fakeServer.create();JIRA.DevStatus.QunitTestUtils.spyAnalyticMethods("Builds",this.sandbox)},teardown:function(){this.sandbox.restore();this.server.restore();JIRA.DevStatus.QunitTestUtils.cleanAllDialogs()},getDetailDialog:function(){var a=AJS.$(".jira-dialog");return{heading:a.find(".devstatus-dialog-heading"),content:a.find(".devstatus-dialog-content")}},createView:function(a,b){return new JIRA.DevStatus.DetailDialogBuildView({count:a,dataType:"build",issueKey:this.issueKey,tabs:{bamboo:{name:"Bamboo",count:b}}})},assertNoNoPermissionMessage:function(){ok(this.getDetailDialog().content.find(".no-permission-to-view-all").length===0,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(this.getDetailDialog().content.find(".aui-message.warning:has(.connection-error)").length===0,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage();this.assertNoConnectionErrorWarning()}});test("Test lock screen renders if no data would be displayed",function(){var f="fecru";var e={detail:[{projects:[]}]};var b=this.createView(7,7);var c=AJS.$("#qunit-fixture");c.html('<div id="tab-content-'+f+'"><div class="detail-content-container"></div></div>');b.$el=c;b.renderSuccess=this.sandbox.spy();b._handleFetchSucceeded(f,e);ok(b.renderSuccess.neverCalledWith(f,e.detail));var d=b.getContentContainer(f);var a=d.find(".no-permission-to-view-all");ok(a.find(".lock-image").length>0,"has lock image");equal(a.text(),"You don't have access to view all related builds. Please contact your administrator.")});test("Test sorting of projects and plans",function(){var a=this.createView(7,7);deepEqual(a.sortProjectsAndPlans([{name:"z",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}},{name:"b",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}}]},{name:"a",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}}]},{name:"M",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}},{name:"b",build:{finishedDate:"2013-10-22T12:03:00.000+0100"}}]}]),[{name:"M",plans:[{name:"b",build:{finishedDate:"2013-10-22T12:03:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}},{name:"a",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}}]},{name:"z",plans:[{name:"b",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}},{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}}]},{name:"a",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}}]}])});test("Test build count",function(){var a=this.createView();equal(a.getBuildCount([]),0,"no projects");equal(a.getBuildCount([{name:"a",plans:[{key:"A-A"}]}]),1,"single project, single build");equal(a.getBuildCount([{name:"z",plans:[{key:"Z-A"},{key:"Z-C"},{key:"Z-B"}]}]),3,"single project, multiple builds");equal(a.getBuildCount([{name:"a",plans:[{key:"A-A"}]},{name:"z",plans:[{key:"Z-A"},{key:"Z-C"},{key:"Z-B"}]}]),4,"multiple projects, multiple builds")});test("Test has artifacts",function(){var a=this.createView();ok(!a.hasArtifacts([]),"no projects");ok(!a.hasArtifacts([{name:"a",plans:[]}]),"single project, no plans");ok(!a.hasArtifacts([{name:"a",plans:[{key:"Z-A"},{key:"Z-C"}]}]),"single project, multiple plans, no build info");ok(!a.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{}},{key:"Z-C",build:{}}]}]),"single project, multiple plans, no artifact info");ok(!a.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{artifacts:[]}},{key:"Z-C",build:{artifacts:[]}}]}]),"single project, multiple plans, empty artifact info");ok(a.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{artifacts:[]}},{key:"Z-C",build:{artifacts:["one"]}}]}]),"single project, multiple plans, got artifact");ok(a.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{artifacts:[]}},{key:"Z-C",build:{artifacts:[]}}]},{name:"b",plans:[{key:"X-A",build:{artifacts:[]}},{key:"X-C",build:{artifacts:["one"]}}]}]),"multiple projects, multiple plans, got artifact")});test("Test dialog title for single build",function(){var a=this.createView(1,1);a.show();var b=this.getDetailDialog();equal(b.heading.text(),"DEV-1: 1 build")});test("Test dialog title for multiple builds",function(){var a=this.createView(2,1);a.show();var b=this.getDetailDialog();equal(b.heading.text(),"DEV-1: 2 builds")});test("Test build detail build dialog with success request",function(){expect(160);JIRA.DevStatus.Date.format="YYYY-MM-DD";var b=this.createView(5);b.show();var e=this.getDetailDialog();var f=e.content.find(".status-loading");var c=e.content.find(".tabs-pane.active-pane");var d=[{name:"Bamboo",plans:[{disabled:false,isBranch:false,build:{date:"2013-11-19",result:"Passed in 2 hours",status:"SUCCESS",latestBuild:5}}]},{name:"Bamboo AAA",plans:[{disabled:false,isBranch:false,build:{date:"2013-11-19",result:"Passed in under 1 second",status:"SUCCESS",latestBuild:5,fixesBuildNumber:4}},{disabled:false,isBranch:true,build:{date:"2013-11-17",result:"Failed in 1 second",status:"FAILED",latestBuild:3}},{disabled:true,isBranch:false,build:{date:"2013-11-15",result:"9 tests passed in 80 seconds",status:"SUCCESS",latestBuild:3}}]},{name:"Bamboo",plans:[{disabled:false,isBranch:false,build:{date:"2013-11-19",result:"Passed in 2 hours",status:"SUCCESS",latestBuild:5}}]},{name:"Bamboo 2",plans:[{disabled:false,isBranch:false,build:{date:"2013-11-13",result:"1 test failed in 27 hours",status:"FAILED",latestBuild:5}},{disabled:false,isBranch:false,build:{date:"2013-11-09",result:"Build incomplete",status:"UNKNOWN",latestBuild:88}},{disabled:true,isBranch:false,build:{date:"2013-11-09",result:"1 test passed in 6 minutes",status:"SUCCESS",latestBuild:3}}]},{name:"Bamboo BBB",plans:[{disabled:false,isBranch:false,build:{date:"2013-11-13",result:"1 test failed in 1 minute",status:"FAILED",latestBuild:5}},{disabled:false,isBranch:true,build:{date:"2013-11-11",result:"1 of 3 tests failed in 88 minutes",status:"FAILED",latestBuild:3}},{disabled:true,isBranch:false,build:{date:"2013-11-09",result:"1 test passed in 1 hour",status:"SUCCESS",latestBuild:3}}]}];ok(f.is(":visible"),"A spinner is visible  when there is an onflight ajax request");ok(f.children().length>0);ok(c.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request");AJS.TestContractManager.respondToRequest("detail3LO-bamboo",this.server.requests[0]);AJS.TestContractManager.respondToRequest("bambooDetailBuild-multiple",this.server.requests[1]);this.assertNoErrorMessagesInCanvas();var a=e.content.find(".detail-builds-container");ok(!f.is(":visible"),"A spinner is no longer visible when the onflight ajax request has completed");ok(!c.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed");equal(a.length,d.length,"Number of project tables rendered into the dialog is correct");_.each(a,_.bind(function(i,h){var k=AJS.$(i);var l="Project["+h+"]: ";var j=k.find(".project-link");equal(j.text(),d[h].name,l+"the project name exist and is correct");strictEqual(j.attr("target"),undefined,l+"clicking on project link opens in the same tab");j.click();ok(JIRA.DevStatus.BuildsAnalytics.fireDetailProjectClicked.called,l+"analytic event is fired correctly when clicking on project link");JIRA.DevStatus.BuildsAnalytics.fireDetailProjectClicked.reset();var g=k.find(".builds-table tr.plan-row");equal(g.length,d[h].plans.length,l+"list of builds exist and contains the correct number of rows");_.each(g,_.bind(function(q,p){var u=AJS.$(q);var y="Project["+h+"], plan["+p+"]: ";var r=d[h].plans[p];var n=r.build;var v=u.find(".plan");var t=v.find(".plan-link");strictEqual(t.attr("target"),undefined,y+"clicking on plan link opens in the same tab");t.click();ok(JIRA.DevStatus.BuildsAnalytics.fireDetailPlanClicked.called,y+"analytic event is fired correctly when clicking on plan link");JIRA.DevStatus.BuildsAnalytics.fireDetailPlanClicked.reset();equal(v.find(".aui-lozenge.disabled").length,r.disabled?1:0,"disabled lozenge present or not");equal(v.find(".aui-icon.aui-iconfont-devtools-branch-small").length,r.isBranch?1:0,"branch icon present or not");var o=u.find(".build");var x=o.find(".aui-icon");if(n.status=="SUCCESS"){ok(x.hasClass("aui-iconfont-approve"),y+"has correct icon")}else{if(n.status=="FAILED"){ok(x.hasClass("aui-iconfont-error"),y+"has correct icon")}else{if(n.status=="UNKNOWN"){ok(x.hasClass("aui-iconfont-devtools-task-cancelled"),y+"has correct icon")}}}var w=o.find(".build-link");equal(w.text(),"#"+n.latestBuild,y+"latest build number is correct");strictEqual(w.attr("target"),undefined,y+"clicking on build link opens in the same tab");w.click();ok(JIRA.DevStatus.BuildsAnalytics.fireDetailBuildClicked.called,y+"analytic event is fired correctly when clicking on build link");JIRA.DevStatus.BuildsAnalytics.fireDetailBuildClicked.reset();var z=u.find(".result");equal(z.text(),n.result,y+"the build result exist and is correct");var m=z.find("a");equal(m.length,0,"fixes build link not present at all times");var s=u.find(".timestamp .livestamp");ok(s.length!=0,y+"time stamp is rendered into the table");equal(s.attr("title"),n.date,y+"tooltip is correctly appended onto the timestamp element")},this))},this))});