/**
 * Automatically handle the rendering of inline dialog for extra reviewers in pull request and review detail dialog
 * when user hover over the number lozenge in the reviewer column
 */
Backbone.define("JIRA.DevStatus.ReviewerInlineDialogView", JIRA.DevStatus.BaseDetailDialogView.extend({
    extraReviewersToolTipTemplate: JIRA.Templates.DevStatus.DetailDialog.extraReviewersTooltip,

    events: {
        "mouseenter": "_onHoverExtraReviewersToolTip",
        "click": "_onClickExtraReviewersToolTip"
    },

    _onHoverExtraReviewersToolTip: function(e) {
        e.preventDefault();

        var instance = this;
        var target = AJS.$(e.target);
        var id = "extrareviewers-tooltip";
        this.activeExtraReviewersToolTip = AJS.InlineDialog(target, id,
            function(content, trigger, showPopup) {
                var $trigger = AJS.$(trigger);
                var parent = $trigger.closest("." + id);
                content.html(instance.extraReviewersToolTipTemplate({
                    reviewers: parent.data("reviewers")
                }));
                // For testing to peek into the content
                instance.activeExtraReviewersToolTip.$content = content;
                showPopup();
            }, {
                cacheContent: false,
                hideDelay: 200,
                onHover: true,
                width: false //Stop AUI from hardcoding inline dialog width
            }
        );
    },

    _onClickExtraReviewersToolTip: function(e) {
        if (this.activeExtraReviewersToolTip) {
            e.stopPropagation();
        }
    }
}));