Backbone.define("JIRA.DevStatus.DetailDialogPullRequestView", JIRA.DevStatus.BaseDetailDialogView.extend({
    template: JIRA.Templates.DevStatus.DetailDialog.pullRequest,
    extraReviewersToolTipTemplate: JIRA.Templates.DevStatus.DetailDialog.extraReviewersTooltip,

    events: {
        "click a.pullrequest-link": "_onClickPullRequestLink"
    },

    initialize: function(options) {
        this.analytics = JIRA.DevStatus.PullRequestsAnalytics;
        JIRA.DevStatus.BaseDetailDialogView.prototype.initialize.call(this, _.extend({
            type: "pullrequest",
            width: 1000,
            height: 400
        }, options));
    },

    renderSuccess: function(applicationType, result) {
        var authorlessPRs = this._removeAuthorFromReviewers(this._extractAllPullRequests(result));
        var pullRequests = this._getSortedPullRequestsByDate(authorlessPRs);
        var pullRequestCount = _.size(pullRequests);
        var container = this.getContentContainer(applicationType);
        if (pullRequestCount > 0) {
            container.html(this.template({
                pullRequests: pullRequests,
                livestampRelativizeThreshold: this.options.livestampRelativizeThreshold,
                pullRequestCount: pullRequestCount,
                reviewersThreshold: this.options.reviewersThreshold
            }));

            this._createReviewersInlineDialog();
            JIRA.DevStatus.Date.addTooltip(container);
        } else {
            container.empty();
        }
        this.renderNoPermissionToViewAllWarningAtBottom(applicationType, pullRequestCount);
        return this;
    },

    getTitle: function(count, issue) {
        return AJS.I18n.getText("devstatus.detail.panel.title.pullrequest", count, issue);
    },

    getOAuthMessageInFooter: function(instances) {
        return AJS.I18n.getText('devstatus.authentication.message.pullrequest', instances.length);
    },

    getOAuthMessageInCanvas: function() {
        return AJS.I18n.getText('devstatus.authentication.authenticate.pullrequest.title');
    },

    getConnectionMessageInCanvas: function() {
        return AJS.I18n.getText('devstatus.authentication.connection-problem.pullrequest.title');
    },

    getNoPermissionToViewAllMessageInCanvas: function() {
        return AJS.I18n.getText('devstatus.authentication.no-permission-to-view-all.pullrequest.title');
    },

    hasData: function(detail) {
        return this._extractAllPullRequests(detail).length > 0;
    },

    _extractAllPullRequests: function(result) {
        return _.compact(_.flatten(_.pluck(result, 'pullRequests')));
    },

    _removeAuthorFromReviewers: function (pullRequests) {
        return _.map(pullRequests, function(pullRequest) {
            if (pullRequest.reviewers && pullRequest.author) {
                var filtered = _.filter(pullRequest.reviewers, function(reviewer) {
                    return reviewer.name != pullRequest.author.name;
                });

                if (pullRequest.reviewers.length == filtered.length) {
                    return pullRequest;
                }

                var result = _.clone(pullRequest);
                result.reviewers = filtered;
                return result;
            }
            return pullRequest;
        });
    },

    _sortReviewers: function (pullRequests) {
        var reviewersThreshold = this.options.reviewersThreshold;
        _.each(pullRequests, function (pullRequest, i) {
            if (_.size(pullRequest.reviewers) > 0) {
                pullRequest.reviewers = _.sortBy(
                    _.filter(pullRequest.reviewers, function(reviewer) {
                        return reviewer.name; // remove reviewers without name as we could not sort them
                    }), function (reviewer) {
                        // approved first
                        return reviewer.approved ? "0" + reviewer.name : "1" + reviewer.name;
                    }
                );
                if (pullRequest.reviewers.length > reviewersThreshold+1) {
                    pullRequest.extraReviewers = JSON.stringify(pullRequest.reviewers.slice(reviewersThreshold));
                }
            }
        });
    },

    _getSortedPullRequestsByDate: function(pullRequests) {
        this._sortReviewers(pullRequests);
        return _.sortBy(pullRequests, 'lastUpdate').reverse();
    },

    _onClickPullRequestLink: function() {
        this.analytics.fireDetailPullRequestClicked(this._getActiveApplicationType());
    }
}));