AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-pullrequest-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");

module("JIRA.DevStatus.CreateReviewFormDialog", {
    setup: function() {
        this.sandbox = sinon.sandbox.create();
        this.issueKey = "DEV-1";
        this.issueId = 10000;
        this.server = sinon.fakeServer.create();
    },
    teardown : function () {
        this.sandbox.restore();
        this.server.restore();
        JIRA.DevStatus.QunitTestUtils.cleanAllDialogs();
    },
    createView: function() {
        this.view = new JIRA.DevStatus.CreateReviewFormDialog({
            linkSelector: 'a',
            applicationType: 'fecru',
            instances: [
                {
                    applicationLinkId: "76ee7557-5c29-36fd-b820-ab8af19abfbd",
                    primary: false,
                    baseUrl: "http://lpater-dev:8060/foo",
                    name: "8060",
                    id: "76ee7557-5c29-36fd-b820-ab8af19abfbd",
                    type: "fecru",
                    typeName: "FishEye / Crucible"
                },
                {
                    applicationLinkId: "f832d6c6-7f3f-3cc3-a011-6706f29b2645",
                    primary: true,
                    baseUrl: "http://lpater-dev:18060",
                    name: "18060",
                    id: "f832d6c6-7f3f-3cc3-a011-6706f29b2645",
                    type: "fecru",
                    typeName: "FishEye / Crucible"
                }]

        });
        return this.view;
    }
});

test("Test cta links are filtered by instances", function() {
    // having
    var view = this.createView();

    // when
    var processed = view._processTargets([
        {
            url: 'valid',
            baseUrl: 'http://lpater-dev:8060/foo'
        },
        {
            url: 'invalid',
            baseUrl: 'http://lpater-dev:9060/foo'
        }
    ]);

    // then
    deepEqual(_.pluck(processed, 'name'), ['8060']);
    deepEqual(_.pluck(processed, 'id'), ['76ee7557-5c29-36fd-b820-ab8af19abfbd']);
    deepEqual(_.pluck(processed, 'url'), ['valid']);
});

test("Test cta links are sorted by instance names", function() {
    // having
    var view = this.createView();

    // when
    var processed = view._processTargets([
        {
            baseUrl: 'http://lpater-dev:8060/foo'
        },
        {
            baseUrl: 'http://lpater-dev:18060'
        }
    ]);

    // then
    deepEqual(_.pluck(processed, 'name'), ['18060', '8060']);
});