AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");

module("JIRA.DevStatus.BaseDetailDialogModel", {
    setup: function() {
        this.issueKey = "AWESOME-1";
        this.baseDetailDialogModel = new JIRA.DevStatus.BaseDetailDialogModel({
            issueKey: this.issueKey
        });
        this.server = sinon.fakeServer.create();
    },
    teardown : function () {
        this.server.restore();
    },
    respondToRequest: function(statusCode, content, index) {
        index = index || 0;
        this.server.requests[index].respond(
            statusCode,
            { "Content-Type": "application/json" },
            content
        );
    }
});

test("Model fetches content on tab switch and fire correct events on ajax success", function() {
    var application = "bitbucket";
    var eventsOrder = [];

    this.baseDetailDialogModel.on("fetchRequested", function(applicationType) {
        equal(applicationType, application);
        eventsOrder.push("fetchRequested");
    });
    this.baseDetailDialogModel.on("fetchSucceeded", function(applicationType, result) {
        equal(applicationType, application);
        eventsOrder.push("fetchSucceeded");
    });

    this.baseDetailDialogModel.switchTab(application);
    equal(eventsOrder.length, 1, "One event has been fired");
    equal(eventsOrder[0], "fetchRequested", "fetchRequested event has been fired");
    equal(this.baseDetailDialogModel.get("selectedTab"), "#tab-menu-bitbucket", "The current active tab is correct");
    equal(this.baseDetailDialogModel.get("selectedPane"), "#tab-content-bitbucket", "The current active pane is correct");

    var contentToRespond = {hello:"world"};
    this.respondToRequest(200, JSON.stringify(contentToRespond)); //success
    equal(eventsOrder.length, 2, "Another event has been fired");
    equal(eventsOrder[1], "fetchSucceeded", "fetchSucceeded event has been fired");

    deepEqual(this.baseDetailDialogModel.get("contentMap")[application], contentToRespond,
        "content from response is stored");
});

test("Model fetches content on tab switch and fire correct events on ajax fail", function() {
    var application = "bitbucket";
    var eventsOrder = [];

    this.baseDetailDialogModel.on("fetchFailed", function(applicationType, result) {
        equal(applicationType, application);
        eventsOrder.push("fetchFailed");
    });

    this.baseDetailDialogModel.switchTab(application);

    this.respondToRequest(500); //fail
    equal(eventsOrder.length, 1, "Event has been fired");
    equal(eventsOrder[0], "fetchFailed", "fetchFailed event has been fired");
    equal(this.baseDetailDialogModel.get("contentMap")[application], undefined, "there is no content from response");
});

test("Switching to a seen tab again does not make an ajax request, unless forced", function() {
    var application = "bitbucket";
    var eventsOrder = [];

    this.baseDetailDialogModel.on("fetchSucceeded", function(applicationType, result) {
        equal(applicationType, application);
        eventsOrder.push("fetchSucceeded");
    });

    this.baseDetailDialogModel.switchTab(application);

    var contentToRespond = {hello: application};
    this.respondToRequest(200, JSON.stringify(contentToRespond));

    equal(eventsOrder.length, 1, "Event has been fired");
    equal(eventsOrder[0], "fetchSucceeded", "fetchSucceeded event has been fired");

    this.baseDetailDialogModel.switchTab("other");
    equal(this.server.requests.length, 2, "Handle request to any server type");

    this.baseDetailDialogModel.switchTab(application);
    equal(this.server.requests.length, 2, "No new request is made");

    this.baseDetailDialogModel.switchTab(application, true);
    equal(this.server.requests.length, 3, "Force fetch will make a new request");
});