AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");(function(){module("JIRA.DevStatus.DevStatusModule",{setup:function(){this.sandbox=sinon.sandbox.create();this.fixture=jQuery("#qunit-fixture");this.devStatusPanel=jQuery('<div id="devstatus-panel"></div>').appendTo(this.fixture);this.devStatusContainer=jQuery('<div id="devstatus-container"></div>').appendTo(this.devStatusPanel);this.statusPanels=jQuery('<div class="status-panels"></div>').appendTo(this.devStatusContainer);this.statusPanelContainer=jQuery('<div><div class="status-panel" data-module="MockModule"></div></div>').appendTo(this.statusPanels);this.messagePanelContainer=jQuery('<div class="message-panel"></div>').appendTo(this.devStatusContainer);this.backupEverything();this.stubEverything()},teardown:function(){this.sandbox.restore();AJS.$.ajax=this.ajax;AJS.$("body").removeClass()},backupEverything:function(){this.ajax=AJS.$.ajax},stubEverything:function(){AJS.$.ajax=this.sandbox.stub()},createModule:function(g){if(g&&g.labs){this.devStatusContainer.attr("data-labs-json",JSON.stringify(g.labs))}var f=e();JIRA.DevStatus.MockModule=function(){return{render:sinon.spy(),startLoading:sinon.spy()}};f.statusPanelContainer=this.statusPanelContainer;f.devStatusContainer={data:sinon.spy(),append:sinon.spy()};f._createDevStatusData({});f._createAnalyticsModel({});f._createSummaryViews({});f._errorModule.render=sinon.spy();f._postRender=sinon.spy();return f},createModuleForNoData:function(){var f=e();f.analyticsModel={getIssue:function(){return{}},getSummary:sinon.stub()};f._isAnySummaryViewVisibleOnPanel=sinon.stub();f._isAnyErrorViewVisible=sinon.stub();f.devStatusPanelVisibilityToggler=sinon.stub();f.parentContainer={is:sinon.stub()};return f}});var c={devStatusContainer:"#qunit-fixture #devstatus-container",parentContainer:"[id$='devstatus-panel']",link:"a.devstatus-cta-link",statusPanel:".status-panels",viewIssueHeader:".mod-header",agileHeader:".ghx-header"};var b={labs:"jira.plugin.devstatus.labs",phaseTwo:"jira.plugin.devstatus.phasetwo"};function e(){var f=new JIRA.DevStatus.DevStatusModule({parentContainerSelector:c.parentContainer,linkSelector:c.link,panelSelector:c.devStatusContainer,statusPanelSelector:c.statusPanel,enableLabs:true,enablePhaseTwo:true,darkFeatures:b});f.parentContainer=jQuery();f.labsOptIn=new JIRA.DevStatus.Labs.LabsOptInModel({allowed:true});return f}function d(){var f=AJS.$.Deferred();AJS.$.ajax.returns(f);return f}function a(f){return jQuery('<div class="dev-summary json-blob"></div>').attr("data-json",JSON.stringify(f))}test("ajax successful",function(){var g=this.createModule(),f=d();g._setupDataEventHandlers();g._startDevStatus();var h=[{instance:{name:"stash1"},data:{}}];f.resolve(h);ok(g._summaryModules[0].render.withArgs(h).calledOnce,"first module is rendered");ok(g._errorModule.render.withArgs(h).calledOnce,"error module is rendered");ok(g._postRender.withArgs().calledOnce,"no data module is rendered")});test("ajax failed",function(){var g=this.createModule(),f=d();g._setupDataEventHandlers();g._startDevStatus();f.reject();ok(g._summaryModules[0].render.withArgs().calledOnce,"first module is rendered with no data");ok(g._errorModule.render.withArgs().calledOnce,"error module is rendered with no data");ok(g._postRender.withArgs().calledOnce,"no data module is rendered")});test("no AJAX call if fresh dev summary JSON is found on the page",function(){this.devStatusContainer.append(a({isStale:false,cachedValue:{instance:{name:"stash1"},data:{}}}));var f=this.createModule();var g=d();f.initializePanel({container:this.devStatusContainer,showTooltip:false,headerSelector:""});f._startDevStatus();equal(AJS.$.ajax.callCount,0,"DevStatusModule should use JSON blob that is on the page")});test("AJAX call is still performed when stale dev summary JSON is found on the page",function(){this.devStatusContainer.append(a({isStale:true,cachedValue:{instance:{name:"stash1"},data:{}}}));var f=this.createModule();var g=d();f.initializePanel({container:this.devStatusContainer,showTooltip:false,headerSelector:""});equal(AJS.$.ajax.callCount,1,"DevStatusModule should use JSON blob that is on the page")});test("stale dev summary data is not cleared when update summary data AJAX fails",function(){var g={instance:{name:"stash1"},data:{}};this.devStatusContainer.append(a({isStale:true,cachedValue:g}));d().reject();var f=this.createModule().initializePanel({container:this.devStatusContainer});ok(this.fixture.find(".connection-error").length==1,"comms error message should be shown");ok(f._summaryModules[0].render.withArgs(g).calledTwice,"stale summary data should be shown")});test("AJAX call is not performed when phase two is disabled",function(){this.devStatusContainer.append(a({isStale:true,cachedValue:{instance:{name:"stash1"},data:{}}}));var f=this.createModule();var g=d();f.initializePanel({container:this.devStatusContainer,showTooltip:false,headerSelector:"",phaseTwoDisabled:true});equal(AJS.$.ajax.callCount,0,"phase two ajax call is not made")});test("is any view visible",function(){var f=e();f.labsOptIn=new JIRA.DevStatus.Labs.LabsOptInModel({allowed:false});f._summaryModules=[{isViewVisible:function(){return true}}];ok(f._isAnySummaryViewVisibleOnPanel(),"visible even if labs not allowed");f.labsOptIn=new JIRA.DevStatus.Labs.LabsOptInModel({allowed:true,optedIn:true});f._summaryModules=[{isViewVisible:function(){return false}}];ok(!f._isAnySummaryViewVisibleOnPanel(),"not visible even if labs opted in");f._summaryModules=[];ok(!f._isAnySummaryViewVisibleOnPanel(),"not visible due to no modules");f._summaryModules=[{isViewVisible:function(){return false}}];ok(!f._isAnySummaryViewVisibleOnPanel(),"not visible due to no modules visible");f._summaryModules=[{isViewVisible:function(){return false}},{isViewVisible:function(){return true}}];ok(f._isAnySummaryViewVisibleOnPanel(),"visible due to some modules visible")});test("is any error view visible",function(){var f=e();f._errorModule={isViewVisible:function(){return true}};ok(f._isAnyErrorViewVisible(),"visible if error is visible");f._errorModule={isViewVisible:function(){return false}};ok(!f._isAnyErrorViewVisible(),"not visible if error is not visible")});test("visibility toggler called with visible when summary view is displayed and container is NOT visible",function(){var f=this.createModuleForNoData();f._isAnySummaryViewVisibleOnPanel.returns(true);f.parentContainer.is.returns(false);f._postRender(true);ok(f.devStatusPanelVisibilityToggler.calledWith(f.parentContainer,true,true),"visibility toggler called with visible when summary view is displayed and container is NOT visible")});test("visibility toggler NOT called with visible when summary view is displayed and container is visible",function(){var f=this.createModuleForNoData();f._isAnySummaryViewVisibleOnPanel.returns(true);f.parentContainer.is.returns(true);f._postRender(true);ok(f.devStatusPanelVisibilityToggler.callCount===0,"visibility toggler NOT called with visible when summary view is displayed and container is visible")});test("visibility toggler called with visible when summary view is not displayed but with create branch and container is NOT visible",function(){var f=this.createModuleForNoData();f._isAnySummaryViewVisibleOnPanel.returns(false);f.createBranchContainer={size:function(){return 1}};f.parentContainer.is.returns(false);f._postRender(false);ok(f.devStatusPanelVisibilityToggler.calledWith(f.parentContainer,true,false),"visibility toggler called with visible when summary view is not displayed but with create branch and container is NOT visible")});test("set the empty-status flag when nothing is rendered for the status panel",function(){var f=AJS.$("<div></div>");var g=this.createModuleForNoData();g.statusPanelContainer=f;g.createBranchContainer={size:function(){return 1}};g._isAnySummaryViewVisibleOnPanel.returns(true);g._postRender(true);equal(f.hasClass("empty-status"),false,"panel doesn't have empty-status when something is being rendered");g._isAnySummaryViewVisibleOnPanel.returns(false);g._postRender(true);equal(f.hasClass("empty-status"),true,"panel HAVE empty-status when nothing is being rendered")});test("visibility toggler NOT called with visible when summary view is not displayed but with create branch and container is visible",function(){var f=this.createModuleForNoData();f._isAnySummaryViewVisibleOnPanel.returns(false);f.createBranchContainer={size:function(){return 1}};f.parentContainer.is.returns(true);f._postRender(false);ok(f.devStatusPanelVisibilityToggler.callCount===0,"visibility toggler NOT called with visible when summary view is not displayed but with create branch and container is visible")});test("visibility toggler called with not visible when summary view is not displayed and no create branch and container is visible",function(){var f=this.createModuleForNoData();f._isAnySummaryViewVisibleOnPanel.returns(false);f.createBranchContainer={size:function(){return 0}};f.parentContainer.is.returns(true);f._postRender(false);ok(f.devStatusPanelVisibilityToggler.calledWith(f.parentContainer,false,false),"visibility toggler called with not visible when summary view is not displayed and no create branch and container is visible")});test("visibility toggler NOT called with not visible when summary view is not displayed and no create branch and container is NOT visible",function(){var f=this.createModuleForNoData();f._isAnySummaryViewVisibleOnPanel.returns(false);f.createBranchContainer={size:function(){return 0}};f.parentContainer.is.returns(false);f._postRender(false);ok(f.devStatusPanelVisibilityToggler.callCount===0,"visibility toggler NOT called with not visible when summary view is not displayed and no create branch and container is NOT visible")});test("calling initializePanel unregisters previously active listeners",function(){var g=this.createModule({labs:{allowed:true,optedIn:true,optedInByAdmin:false,dismissed:false}});var f=d();g.initializePanel({container:this.devStatusContainer,showTooltip:false,headerSelector:""});var h=d();g.initializePanel({container:this.devStatusContainer,showTooltip:false,headerSelector:""});f.resolve([{instance:{name:"stash1"},data:{}}]);ok(this.fixture.find(".connection-error").length==0,"comms error message should not be shown if AJAX for non-visible panel succeeds");h.reject();ok(this.fixture.find(".connection-error").length==1,"comms error message should be shown if AJAX fails")})})();