AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");

(function() {

module("JIRA.DevStatus.DevStatusInit", {
    ASSERT_EXPECT: 6,
    setup: function() {
        this.sandbox = sinon.sandbox.create();
        this.fixture = jQuery("#qunit-fixture");
        this.body = jQuery("<body></body>").appendTo(this.fixture);
        this.containerId = "devstatus-container";
        // Stub out defer from underscore because our helptip uses it to defer to execution of the code to wait for
        // completion of KA code
        this.deferStub = JIRA.DevStatus.QunitTestUtils.mockDefer();
        this.backupEverything();

        JIRA.DevStatus.showTooltip = true;
        this.stubEverything();
    },
    teardown : function () {
        this.sandbox.restore();
        this.deferStub.restore();
        if (this.panelContainer) {
            this.panelContainer.remove();
        }
        JIRA.Issues = this.originalIssuesApi;
        AJS.Darkfeatures = this.originalDarkFeaturesApi;
        this.body.removeClass();
    },
    createPanel: function(labsToggle, phaseTwoToggles) {
        this.panelContainer = jQuery('<div id="something-devstatus-panel"></div>').appendTo(this.body);
        this.agileLink = jQuery('<a href="#ghx-tab-com-atlassian-jira-plugins-'
                + 'jira-development-integration-plugin-greenhopper-devstatus-panel">XX</a>').appendTo(this.panelContainer);
        this.devStatusPanel = jQuery('<div id="' + this.containerId + '"><a class="devstatus-cta-link" href="#devstatus.cta.createbranch"></a><div class="status-panels"></div></div>')
                .attr('data-labs-json', JSON.stringify({ allowed: labsToggle, optedIn: phaseTwoToggles }))
                .appendTo(this.panelContainer);
    },
    createDashboardBody: function() {
        this.body.addClass("page-type-dashboard");
    },
    createJIRAAgileBody: function() {
        this.body.addClass("ghx-agile");
    },
    createKABody: function() {
        this.body.addClass("ka ajax-issue-search-and-view");
    },
    backupEverything: function() {
        this.originalIssuesApi = JIRA.Issues;
        this.originalDarkFeaturesApi = AJS.Darkfeatures;
    },
    stubEverything: function() {
        this.helpTipStub = this.sandbox.stub(AJS.HelpTip.Manager, "showSequences");
        JIRA.Issues = {Api: {
            isFullScreenIssueVisible: this.sandbox.stub(),
            getSelectedIssueKey: this.sandbox.stub()
        }};
        AJS.DarkFeatures = {
            isEnabled: this.sandbox.stub()
        };
    },
    assertDevStatusModules: function (origin, hasPanel, hasHelptip, isLabsEnabled, isPhaseTwoEnabled) {
        //Modules that will always be initialised regardless
        this.ok(JIRA.DevStatus.devStatusModule, true, "DevStatusModule has been initialised");
        this.ok(JIRA.DevStatus.devStatusModule.createBranchFormDialog, true, "CreateBranchFormDialog has been initialised");

        //Modules that are only initialised if panel exist
        this.ok(JIRA.DevStatus.devStatusModule.createBranchView, hasPanel, this.createMessage(origin, hasPanel, "CreateBranchView"));

        //Helptip is only initialised if panel exist AND helptip is enabled
        var helptipSwitch = hasPanel && hasHelptip && (!isLabsEnabled || isPhaseTwoEnabled);
        ok(this.helpTipStub.called === helptipSwitch, this.createMessage(origin, helptipSwitch, "Helptip"));
    },
    ok: function(object, isTruthy, msg) {
        ok(_.isObject(object) === isTruthy, msg);
    },
    createMessage: function(origin, condition, module) {
        var switchMessage = condition ? "enables" : "disables";
        return "Initialisation from " + origin + " " + switchMessage + " the " + module;
    },
    testInitFromDashboard: function (isLabsEnabled, isPhaseTwoEnabled) {
        this.createDashboardBody();
        this.createPanel(isLabsEnabled, isPhaseTwoEnabled);
        //Manually trigger a document ready init
        JIRA.DevStatus.documentReadyInit(this.fixture);
        this.assertDevStatusModules("dashboard", false, false, isLabsEnabled, isPhaseTwoEnabled);
    },
    testInitFromServerLoadedViewIssue: function(isLabsEnabled, isPhaseTwoEnabled) {
        JIRA.Issues.Api.isFullScreenIssueVisible.returns(true);
        this.createKABody();
        this.createPanel(isLabsEnabled, isPhaseTwoEnabled);

        //Manually trigger a document ready init
        JIRA.DevStatus.documentReadyInit(this.fixture);

        this.assertDevStatusModules("server loaded view issue page", true, true, isLabsEnabled, isPhaseTwoEnabled);
    },
    testInitFromAjaxViewIssue: function(isLabsEnabled, isPhaseTwoEnabled) {
        JIRA.Issues.Api.isFullScreenIssueVisible.returns(false);
        this.createKABody();
        this.createPanel(isLabsEnabled, isPhaseTwoEnabled);

        JIRA.DevStatus.documentReadyInit(this.fixture);

        JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [this.panelContainer, JIRA.CONTENT_ADDED_REASON.pageLoad]);
        this.assertDevStatusModules("ajax loaded view issue page", true, true, isLabsEnabled, isPhaseTwoEnabled);
    },
    testInitFromJIRAAgile: function(isLabsEnabled, isPhaseTwoEnabled) {
        this.createJIRAAgileBody();
        this.createPanel(isLabsEnabled, isPhaseTwoEnabled);

        JIRA.DevStatus.documentReadyInit(this.fixture);

        JIRA.trigger("GH.DetailView.updated", [this.panelContainer, JIRA.CONTENT_ADDED_REASON.pageLoad ]);

        this.assertDevStatusModules("JIRA agile detail view", true, false, isLabsEnabled, isPhaseTwoEnabled);
    },
    testAgileLinkClickedEvent : function(isLabsEnabled, isPhaseTwoEnabled) {
        this.createJIRAAgileBody();
        this.createPanel(isLabsEnabled, isPhaseTwoEnabled);

        JIRA.DevStatus.Analytics.fireAgileDevStatusLinkClicked = this.sandbox.spy();

        JIRA.DevStatus.documentReadyInit(this.fixture);
        JIRA.trigger("GH.DetailView.updated", [this.panelContainer, JIRA.CONTENT_ADDED_REASON.pageLoad ]);

        this.agileLink.click();

        equal(JIRA.DevStatus.Analytics.fireAgileDevStatusLinkClicked.callCount, 1);
    },
    testAgileLinkClickedEventMultiInit : function(isLabsEnabled, isPhaseTwoEnabled) {
        this.createJIRAAgileBody();
        this.createPanel(isLabsEnabled, isPhaseTwoEnabled);

        JIRA.DevStatus.Analytics.fireAgileDevStatusLinkClicked = this.sandbox.spy();

        JIRA.DevStatus.documentReadyInit(this.fixture);
        // We trigger the updated event several times to see if this will call the analytics event multiple times.
        JIRA.trigger("GH.DetailView.updated", [this.panelContainer, JIRA.CONTENT_ADDED_REASON.pageLoad ]);
        JIRA.trigger("GH.DetailView.updated", [this.panelContainer, JIRA.CONTENT_ADDED_REASON.pageLoad ]);
        JIRA.trigger("GH.DetailView.updated", [this.panelContainer, JIRA.CONTENT_ADDED_REASON.pageLoad ]);

        this.agileLink.click();

        // Note: This could be called three times if the implementation is wrong.
        equal(JIRA.DevStatus.Analytics.fireAgileDevStatusLinkClicked.callCount, 1);
    }
});

//Exhaustive test of all combinations. Why? It's qunit, it's CHEAP
var tests = [
    {
        message: "Loading DevStatus from Dashboard disables helptip and only load FormDialog.",
        test: "testInitFromDashboard"
    },
    {
        message: "Loading DevStatus from JIRA server loaded view issue enables helptip and load everything else.",
        test: "testInitFromServerLoadedViewIssue"
    },
    {
        message: "Loading DevStatus from JIRA View Issue enables helptip and load everything else.",
        test: "testInitFromAjaxViewIssue"
    },
    {
        message: "Loading DevStatus from JIRA Agile disables helptip but load everything else.",
        test: "testInitFromJIRAAgile"
    },
    {
        message: "Clicking the JIRA Agile link for devstatus fires an event once",
        test: "testAgileLinkClickedEvent"
    },
    {
        message: "Clicking the JIRA Agile link for devstatus fires an event once when initialised many times",
        test: "testAgileLinkClickedEventMultiInit"
    }
];
var toggleCase = [true, false];

_.each(tests, function(testCase) {
    _.each(toggleCase, function(isLabsOn) {
        var labsMessage = isLabsOn ? "on" : "off";
        _.each(toggleCase, function(isPhaseTwoOn) {
            var phaseTwoMessage = isPhaseTwoOn ? "on" : "off";
            test(testCase.message + " Labs " + labsMessage + ". Phase two " + phaseTwoMessage + ".", function() {
                this[testCase.test](isLabsOn, isPhaseTwoOn);
            });
        });
    });
});

test("Test regex for devStatusDetailDialog", function() {
    expect(2 * 8);

    var metaKey = "fusion-open-detail-dialog";
    var getUrlStub = this.sandbox.stub(JIRA.DevStatus.Navigate, "getUrl");
    function assertAndReset(fullUrl, expectedValue) {
        equal(AJS.Meta.get(metaKey), undefined, "AJS.Meta is empty for fusion-open-detail-dialog");
        getUrlStub.returns(fullUrl);
        JIRA.DevStatus.setDetailDialogParam();
        equal(AJS.Meta.get(metaKey), expectedValue, "AJS.Meta is equal to '" + expectedValue + "' for url '" + fullUrl+ "'");
        AJS.Meta.set(metaKey, undefined);
    }

    var testCase = [
        ["branch", "/browse/XSS-1?devStatusDetailDialog=branch"],
        ["review", "/browse/XSS-2?jql=&devStatusDetailDialog=review"],
        ["repository", "/browse/DEV-3?jql=something&startIndex=50&devStatusDetailDialog=repository"],
        ["deployment-environment", "/browse/DEV-4?jql=something&devStatusDetailDialog=deployment-environment&startIndex=50"],
        ["pullrequest", "/browse/DEV-4?jql=something&devStatusDetailDialog=pullrequest&startIndex=50&longcrap="],
        ["build", "/browse/DEV-4?devStatusDetailDialog=build&startIndex=50&longcrap=awdawdawdwpokemon"],
        ["create-branch", "http://localhost:2990/jira/i#browse/DEV-2?jql=project%2520%253D%2520DEV&devStatusDetailDialog=create-branch"],
        ["pikachu", "https://jdog.jira-dev.com/browse/JDEV-24823?jql=project%20in%20(FUSE%2C%20JDEV)%20AND%20status%20%3D%20%22In%20Progress%22&devStatusDetailDialog=pikachu&wut=doge&anime=pokemon"]
    ];

    _.each(testCase, function(testCase) {
        assertAndReset(testCase[1], testCase[0]);
    });
});

})();
