AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:utils");
AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils");

module("JIRA.DevStatus.Util.Listeners", {
    setup: function() {
        this.oldNavigate = JIRA.DevStatus.Navigate;
        JIRA.DevStatus.Navigate = {
            getUrl: sinon.stub()
        }
    },

    teardown: function() {
        JIRA.DevStatus.Navigate = this.oldNavigate;
    },

    verifyUrlWithSummaryParamIsEncodedCorrectly: function(extraUrl, message) {
        var summaryType = "summary";
        var url = "http://localhost:1234/path/to/file.ext" + (extraUrl||"");
        var summaryUrl = (extraUrl?"&":"?") + "devStatusDetailDialog=summary";
        JIRA.DevStatus.Navigate.getUrl.returns(url);
        equal(url + summaryUrl, JIRA.DevStatus.URL.getUrlWithDetailDialogParam(summaryType), message);
    }
});

test("getUrlWithDetailDialogParam encode the URL correctly", function() {
    // Empty URL
    this.verifyUrlWithSummaryParamIsEncodedCorrectly("", "URL without query");

    // Url with an argument
    this.verifyUrlWithSummaryParamIsEncodedCorrectly("?param=value", "URL with a simple query");

    // Url with a partially encoded argument
    this.verifyUrlWithSummaryParamIsEncodedCorrectly("?expression=A %3D B", "URL with a partially encoded query");

    // Url with an fully encoded argument
    this.verifyUrlWithSummaryParamIsEncodedCorrectly("?expression=%3D%7B%26%3D%3F%23%7D", "URL with a fully encoded query");
});
