AJS.test.require("com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-panel-resources");

module("JIRA.DevStatus.AnalyticsWithCtaDialog", {
    linkSelector : 'a.devstatus-cta-link',
    dialogId : 'devstatus-cta-dialog',
    panelSelector : "#devstatus-container",

    issueType : "issue type",
    issueStatus : "issue status",
    host : "host abc",
    title : "title def",

    setup : function () {
        this.sandbox = sinon.sandbox.create();
        this.navigateStub = this.sandbox.stub(JIRA.DevStatus.Navigate, "navigate");
        this.server = sinon.fakeServer.create();

        var fixture = jQuery("#qunit-fixture");

        this.devStatusPanel = jQuery('<div id="devstatus-container">').appendTo(fixture);
        //DevStatusModule is initialised by default on document ready. This will also initialise the analytics stuff
        //We simply take it off again, because DevStatusModule will be initialised again at the start of each test
        jQuery(document).off("click", "a.devstatus-cta-link");
    },

    teardown : function () {
        this.server.restore();
        this.sandbox.restore();
        //Unbind all the things!
        JIRA.unbind(JIRA.Events.NEW_CONTENT_ADDED);
        JIRA.unbind("GH.DetailView.updated");
        jQuery(document).off("click", "a.devstatus-cta-link");
        jQuery(document).off("click", "#" + this.linkSelector + " .jira-dialog-content .target");
        jQuery(document).off("click", "#" + this.linkSelector + " .jira-dialog-content button.cancel");
    },

    createCreateBranchButton : function (issueType, issueStatus, isAssignee) {
        jQuery('<a href="#devstatus.cta.createbranch" class="devstatus-cta-link" ' +
            ' data-issueid="12345"' +
            ' data-issue-type="' + issueType + '"' +
            ' data-issue-status="' + issueStatus + '"' +
            ' data-is-assignee="' + isAssignee + '">').appendTo(this.devStatusPanel);
    },

    getCreateBranchButton : function () {
        return this.devStatusPanel.find(this.linkSelector);
    },

    _assertEventProperty : function (event, propertyName, expectedValue) {
        equal(event.properties[propertyName], expectedValue, "Triggered event has the right '" + propertyName + "' attribute");
    },

    _assertEventProperties : function (event, expectedProperties) {
        var instance = this;
        _.each(expectedProperties, function (value, key) {
            instance._assertEventProperty(event, key, value);
        });
    },

    _assertCtaEvent : function (event, name, isAssignee, extraProperties) {
        equal(event.name, "devstatus.createbranch." + name + "." + (isAssignee ? "assignee" : "nonassignee"), "Triggered event has the right name");
        this._assertEventProperty(event, "issueType", this.issueType);
        this._assertEventProperty(event, "issueStatus", this.issueStatus);
        extraProperties && this._assertEventProperties(event, extraProperties);
    },

    mockEventQueueAndRunTest : function(theTest) {
        var existingDarkFeatures = AJS.DarkFeatures;

        try {
            AJS.EventQueue = {
                push: sinon.spy()
            };

            AJS.DarkFeatures = {
                isEnabled : function(key) {
                    return false;
                }
            };

            // tests always have 0 parameters
            theTest.call(this);
        } finally {
            AJS.DarkFeatures = existingDarkFeatures;
        }
    },

    _respondToAjaxRequest : function(targetCount) {
        targetCount = targetCount || 2;
        var targets = [
            {"name":"Stash Dev","url":"https://stash.dev.internal.atlassian.com/?issueKey=ANGRY-1&issueType=Story&issueSummary=Build+Catapult","iconUrl":""},
            {"name":"Atlassian JIRA","url":"https://jira.atlassian.com/?issueKey=ANGRY-1&issueType=Story&issueSummary=Build+Catapult","iconUrl":""}
        ].splice(0, targetCount); //From index 0, take targetCount element(s)
        this.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(
            {
                prompt: "Where do you want to create the branch?",
                remoteApps: targets
            }
        ));
    },

    testCtaDialogOpen : function(origin, isAssignee, targetCount) {
        this.mockEventQueueAndRunTest(function() {
            //The order between creating the create branch button and devstatus module is different from
            //jira view issue, issue nav and jira agile
            if (origin === "viewIssue") {
                this.createCreateBranchButton(this.issueType, this.issueStatus, isAssignee);
                this.devStatusModule = new JIRA.DevStatus.DevStatusModule({
                    linkSelector: this.linkSelector,
                    panelSelector: this.panelSelector,
                    parentContainerSelector: this.panelSelector
                });
            } else {
                this.devStatusModule = new JIRA.DevStatus.DevStatusModule({
                    linkSelector: this.linkSelector,
                    panelSelector: this.panelSelector,
                    parentContainerSelector: this.panelSelector
                });
                this.createCreateBranchButton(this.issueType, this.issueStatus, isAssignee);

                if (origin === "issueNav") {
                    // simulating issue nav, the button is created after page load, but before the NEW_CONTENT_ADDED trigger
                    JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [this.devStatusPanel, JIRA.CONTENT_ADDED_REASON.dialogReady ]);
                } else if (origin === "jiraAgile") {
                    // simulating jira agile, the javascript event is fired when the detail panel has been rendered
                    JIRA.trigger("GH.DetailView.updated", [this.devStatusPanel]);
                }
            }

            try {
                this.getCreateBranchButton().click();
                this._respondToAjaxRequest(targetCount);

                var expectedAnalytic;
                if (targetCount === 1) {
                    ok(this.navigateStub.called, "Page navigates with one remote app");
                    expectedAnalytic = "click";
                } else {
                    ok(!this.navigateStub.called, "Page doesn't navigate with multiple remote apps");
                    expectedAnalytic =  "dialog.open";
                }

                ok(AJS.EventQueue.push.calledBefore(this.navigateStub), "Event queue is called before navigate");
                equal(AJS.EventQueue.push.callCount, targetCount, "Triggered events");
                var event = AJS.EventQueue.push.args[targetCount-1][0];
                this._assertCtaEvent(event, expectedAnalytic, isAssignee);
            } finally {
                // clean up the jira dialog
                JIRA.DevStatus.CtaDialog.dialog.hide();
            }
        });
    }
});

_.each([1,2], function(targetCount) {
    test("Open cta dialog triggers event for assignee on single view issue page with " + targetCount + " remote app(s).", function() {
        expect(6);
        this.testCtaDialogOpen("viewIssue", true, targetCount);
    });

    test("Open cta dialog triggers event for assignee on issue nav with " + targetCount + " remote app(s).", function() {
        expect(6);
        this.testCtaDialogOpen("issueNav", true, targetCount);
    });

    test("Open cta dialog triggers event for assignee on jira agile with " + targetCount + " remote app(s).", function() {
        expect(6);
        this.testCtaDialogOpen("jiraAgile", true, targetCount);
    });

    test("Open cta dialog triggers event for non assignee on single view issue page with " + targetCount + " remote app(s).", function() {
        expect(6);
        this.testCtaDialogOpen("viewIssue", false, targetCount);
    });

    test("Open cta dialog triggers event for non assignee on issue nav with " + targetCount + " remote app(s).", function() {
        expect(6);
        this.testCtaDialogOpen("issueNav", false, targetCount);
    });

    test("Open cta dialog triggers event for non assignee on jira agile with " + targetCount + " remote app(s).", function() {
        expect(6);
        this.testCtaDialogOpen("jiraAgile", false, targetCount);
    });
});
