/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.web.admin;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.devstatus.api.DevStatusPermissionService;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationService;
import com.atlassian.jira.plugin.devstatus.api.PermissionHolders;
import com.atlassian.jira.plugin.devstatus.api.SupportedApplication;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ProjectAdminContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_PROJECT_KEY = "project";
    static final int MAX_SUPPORTED_APPLICATION = 5;
    static final String SUPPORTED_APPLICATIONS = "supportedApplications";
    static final String NUM_SUPPORTED_APPLICATIONS = "totalSupportedApplications";
    static final String PERMISSION_HOLDERS = "permissionHolders";
    static final String PERMISSION_SCHEME_ID = "permissionSchemeId";
    static final String BASE_URL = "baseUrl";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DevStatusPermissionService devStatusPermissionService;
    private final DevStatusSupportedApplicationService devStatusSupportedApplicationService;
    private final PermissionSchemeManager permissionSchemeManager;
    private final JiraBaseUrls jiraBaseUrls;

    @Inject
    public ProjectAdminContextProvider(DevStatusPermissionService devStatusPermissionService, DevStatusSupportedApplicationService devStatusSupportedApplicationService, @ComponentImport PermissionSchemeManager permissionSchemeManager, @ComponentImport JiraBaseUrls jiraBaseUrls) {
        this.devStatusPermissionService = devStatusPermissionService;
        this.devStatusSupportedApplicationService = devStatusSupportedApplicationService;
        this.permissionSchemeManager = permissionSchemeManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Project project = this.getProject(context);
        return project == null ? this.getClass().getName() : project.getKey();
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HashMap newContext = Maps.newHashMap(context);
        this.addPermissionHolders(newContext);
        this.addSupportedApplications(newContext);
        this.addPermissionSchemeId(newContext);
        newContext.put(BASE_URL, this.jiraBaseUrls.baseUrl());
        return newContext;
    }

    private void addPermissionHolders(Map<String, Object> context) {
        Project project = this.getProject(context);
        ServiceOutcome<PermissionHolders> permissionHolders = this.devStatusPermissionService.getPermissionHolders(project);
        if (!permissionHolders.isValid()) {
            this.log.error("Could not retrieve permission holders: {}", (Object)StringUtils.join((Object[])new Object[]{permissionHolders.getErrorCollection(), ", "}));
        } else {
            context.put(PERMISSION_HOLDERS, permissionHolders.getReturnedValue());
        }
    }

    private void addSupportedApplications(Map<String, Object> context) {
        ImmutableList supportedApps;
        ServiceOutcome<List<SupportedApplication>> outcome = this.devStatusSupportedApplicationService.getSupportedApplications();
        Object object = supportedApps = outcome.isValid() ? (List)outcome.getReturnedValue() : ImmutableList.of();
        if (supportedApps.size() > 5) {
            context.put(NUM_SUPPORTED_APPLICATIONS, supportedApps.size());
            context.put(SUPPORTED_APPLICATIONS, supportedApps.subList(0, 5));
        } else {
            context.put(SUPPORTED_APPLICATIONS, supportedApps);
        }
    }

    private void addPermissionSchemeId(Map<String, Object> context) {
        Scheme scheme;
        Project project = this.getProject(context);
        if (project != null && (scheme = this.permissionSchemeManager.getSchemeFor(project)) != null) {
            context.put(PERMISSION_SCHEME_ID, scheme.getId());
        }
    }

    private Project getProject(Map<String, Object> context) {
        return (Project)context.get(CONTEXT_PROJECT_KEY);
    }
}

