/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.web;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.devstatus.impl.NavigationKeys;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.navlink.consumer.menu.services.RemoteNavigationLinkService;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLinkPredicates;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class CallToActionLinkFactory
implements SimpleLinkFactory {
    static final String CONTEXT_KEY_ISSUE = "issue";
    protected final RemoteNavigationLinkService remoteNavigationLinkService;
    protected final I18nHelper i18nHelper;
    private String navigationKey;

    public CallToActionLinkFactory(@ComponentImport RemoteNavigationLinkService remoteNavigationLinkService, I18nHelper i18nHelper) {
        this.remoteNavigationLinkService = remoteNavigationLinkService;
        this.i18nHelper = i18nHelper;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
        this.navigationKey = NavigationKeys.SECTION_TO_KEY.get(descriptor.getSection());
        if (StringUtils.isEmpty((CharSequence)this.navigationKey)) {
            throw new IllegalArgumentException("The section '" + descriptor.getSection() + "' is not defined for " + this.getClass().getSimpleName());
        }
    }

    @Nonnull
    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        Set<NavigationLink> navigationLinks = this.getNavigationLinks(this.navigationKey);
        Issue issue = (Issue)params.get(CONTEXT_KEY_ISSUE);
        return this.createLinks(navigationLinks, issue);
    }

    @VisibleForTesting
    Set<NavigationLink> getNavigationLinks(String navigationKey) {
        Predicate allMenuItems = NavigationLinkPredicates.keyEquals((String)navigationKey);
        return this.remoteNavigationLinkService.matching(this.i18nHelper.getLocale(), allMenuItems);
    }

    @VisibleForTesting
    List<SimpleLink> createLinks(Set<? extends NavigationLink> navigationLinks, final Issue issue) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(navigationLinks, (Function)new Function<NavigationLink, SimpleLink>(){

            public SimpleLink apply(NavigationLink navigationLink) {
                return CallToActionLinkFactory.this.newSimpleLink(navigationLink, issue);
            }
        }));
    }

    private SimpleLink newSimpleLink(NavigationLink navigationLink, Issue issue) {
        String applicationLinkId = navigationLink.getSource().id();
        String navigationLinkLabel = navigationLink.getLabel();
        String navigationLinkTooltip = navigationLink.getTooltip();
        String id = this.navigationKey + '-' + applicationLinkId;
        String url = this.createSimpleLinkUrl(navigationLink.getHref(), issue);
        String iconUrl = navigationLink.getIconUrl();
        ImmutableMap params = ImmutableMap.of((Object)"baseUrl", (Object)navigationLink.getBaseUrl(), (Object)"applicationType", (Object)navigationLink.getApplicationType());
        return new SimpleLinkImpl(id, navigationLinkLabel, navigationLinkTooltip, iconUrl, null, (Map)params, url, null);
    }

    @VisibleForTesting
    String createSimpleLinkUrl(String baseUrl, Issue issue) {
        if (issue == null) {
            return baseUrl;
        }
        boolean hasQueryParams = baseUrl.indexOf(63) != -1;
        String params = this.generateQueryString(issue);
        return baseUrl + (hasQueryParams ? (char)'&' : '?') + params;
    }

    protected abstract String generateQueryString(Issue var1);
}

