/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.util;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SecurityHelper {
    private static final Logger logger = LoggerFactory.getLogger(SecurityHelper.class);
    private final JiraAuthenticationContext authenticationContext;

    @Inject
    public SecurityHelper(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T doAsUser(String reason, @Nullable ApplicationUser impersonatingUser, Operation<T, E> operation) throws E {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        try {
            logger.debug("Impersonating from current user ({}) as ({}) due to reason: {}", new Object[]{currentUser, impersonatingUser, reason});
            this.authenticationContext.setLoggedInUser(impersonatingUser);
            T t = operation.perform();
            return t;
        }
        finally {
            this.authenticationContext.setLoggedInUser(currentUser);
        }
    }

    public static interface UncheckedOperation<T>
    extends Operation<T, RuntimeException> {
        @Override
        public T perform();
    }

    public static interface Operation<T, E extends Throwable> {
        public T perform() throws E;
    }
}

