/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.summary.cache;

import com.atlassian.jira.plugin.devstatus.api.DevStatusSummaryService;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderHelper;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryData;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryDataBuilder;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.DevSummaryStore;
import com.atlassian.jira.plugin.devstatus.rest.SummaryBean;
import com.atlassian.jira.plugin.devstatus.summary.cache.DevSummary;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DevSummaryCache {
    private static final Logger logger = LoggerFactory.getLogger(DevSummaryCache.class);
    private final DevSummaryStore devSummaryStore;
    private final DataProviderHelper dataProviderHelper;
    private final DevStatusSummaryService devStatusSummaryService;

    @Inject
    public DevSummaryCache(DevSummaryStore devSummaryStore, DataProviderHelper dataProviderHelper, DevStatusSummaryService devStatusSummaryService) {
        this.devSummaryStore = devSummaryStore;
        this.dataProviderHelper = dataProviderHelper;
        this.devStatusSummaryService = devStatusSummaryService;
    }

    @Nullable
    public SummaryBean getDevSummary(long issueId) {
        DevSummary devSummary = this.getDevSummary(issueId, false);
        return devSummary != null ? devSummary.cachedValue : null;
    }

    @Nullable
    public DevSummary getDevSummary(long issueId, boolean returnStaleData) {
        Collection<DataProvider> providers = this.dataProviderHelper.getDataProviders();
        Map<DataProvider, Optional<DataProviderResponse>> cachedResponses = this.fetchCachedResponses(issueId, providers);
        boolean isStale = DevSummaryCache.hasExpiredOrMissingResponses(cachedResponses);
        if (isStale && !returnStaleData) {
            logger.debug("Cached summary for issue {} is stale. Returning null", (Object)issueId);
            logger.trace("Cached responses: {}", cachedResponses);
            return null;
        }
        SummaryDataBuilder builder = SummaryData.builder();
        for (Map.Entry<DataProvider, Optional<DataProviderResponse>> response : cachedResponses.entrySet()) {
            DataProvider provider = response.getKey();
            Optional<DataProviderResponse> cachedResponse = response.getValue();
            if (!cachedResponse.isPresent()) continue;
            builder.addSuccess(provider.getSource(), ((DataProviderResponse)cachedResponse.get()).jsonBytes());
        }
        SummaryBean summaryBean = this.devStatusSummaryService.combineAggregatedData(issueId, builder.build());
        logger.debug("Returning cached summary for issue {}: {}", (Object)issueId, (Object)summaryBean);
        return new DevSummary(summaryBean, isStale);
    }

    private static boolean hasExpiredOrMissingResponses(Map<DataProvider, Optional<DataProviderResponse>> providerResponses) {
        for (Optional<DataProviderResponse> response : providerResponses.values()) {
            if (response.isPresent() && !DevSummaryCache.isBeforeNow(((DataProviderResponse)response.get()).staleAfter())) continue;
            return true;
        }
        return false;
    }

    private static boolean isBeforeNow(Date date) {
        return date != null && new DateTime((Object)date).isBeforeNow();
    }

    private Map<DataProvider, Optional<DataProviderResponse>> fetchCachedResponses(long issueId, Collection<DataProvider> providers) {
        Map<String, DataProviderResponse> responsesBySourceId = this.devSummaryStore.getAll(issueId);
        HashMap providerResponses = Maps.newHashMap();
        for (DataProvider provider : providers) {
            Source source = provider.getSource();
            providerResponses.put(provider, Optional.fromNullable((Object)responsesBySourceId.get(source.getId())));
        }
        return providerResponses;
    }
}

