/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.dvcs;

import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsLinkServiceAccessor;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsLinkService;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DvcsFacade {
    private final DvcsLinkServiceAccessor dvcsLinkServiceAccessor;

    @Inject
    public DvcsFacade(DvcsLinkServiceAccessor dvcsLinkServiceAccessor) {
        this.dvcsLinkServiceAccessor = dvcsLinkServiceAccessor;
    }

    public boolean hasDvcsAccounts(DvcsApplicationType applicationType) {
        DvcsLinkService dvcsLinkService = this.dvcsLinkServiceAccessor.getService();
        return dvcsLinkService != null && !Iterables.isEmpty((Iterable)dvcsLinkService.getDvcsLinks(false, applicationType.getType()));
    }

    public static enum DvcsApplicationType {
        BITBUCKET("bitbucket"),
        GITHUB("github"),
        GITHUB_ENTERPRISE("githube");

        private final String type;

        private DvcsApplicationType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public boolean matches(String type) {
            return this.type.equals(type);
        }
    }
}

