/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.dvcs;

import com.atlassian.fusion.schema.common.PullRequestState;
import com.atlassian.fusion.schema.summary.Summary;
import com.atlassian.fusion.schema.summary.SummaryTarget;
import com.atlassian.fusion.schema.summary.objects.BranchesObject;
import com.atlassian.fusion.schema.summary.objects.CommitsObject;
import com.atlassian.fusion.schema.summary.objects.PullRequestsObject;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsBranchServiceAccessor;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsChangesetServiceAccessor;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsPullRequestServiceAccessor;
import com.atlassian.jira.plugin.devstatus.optionaldep.DvcsRepositoryServiceAccessor;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.IssueDataRequest;
import com.atlassian.jira.plugin.devstatus.provider.LoggingDecorator;
import com.atlassian.jira.plugin.devstatus.provider.data.ExceptionThrownError;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.source.ThreadPool;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.ChangesetDetailsFetcher;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsApplicationTypeInfo;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsCommitDetailHelper;
import com.atlassian.jira.plugin.devstatus.provider.source.dvcs.DvcsPullRequestDetailHelper;
import com.atlassian.jira.plugins.dvcs.model.Branch;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.PullRequest;
import com.atlassian.jira.plugins.dvcs.model.PullRequestRef;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsBranchService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsChangesetService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsPullRequestService;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;

public class DvcsDataProvider
implements DataProvider {
    private final DvcsBranchServiceAccessor branchServiceAccessor;
    private final DvcsChangesetServiceAccessor changesetServiceAccessor;
    private final DvcsPullRequestServiceAccessor pullRequestServiceAccessor;
    private final DvcsCommitDetailHelper commitDataProvider;
    private final DvcsPullRequestDetailHelper pullRequestDataProvider;
    private ExecutorService executor;
    private DvcsApplicationTypeInfo dvcsType;

    public DvcsDataProvider(DvcsBranchServiceAccessor branchServiceAccessor, DvcsChangesetServiceAccessor changesetServiceAccessor, DvcsPullRequestServiceAccessor pullRequestServiceAccessor, DvcsRepositoryServiceAccessor repositoryServiceAccessor, ChangesetDetailsFetcher changesetDetailsFetcher) {
        this.branchServiceAccessor = branchServiceAccessor;
        this.changesetServiceAccessor = changesetServiceAccessor;
        this.pullRequestServiceAccessor = pullRequestServiceAccessor;
        this.commitDataProvider = new DvcsCommitDetailHelper(changesetServiceAccessor, repositoryServiceAccessor, changesetDetailsFetcher);
        this.pullRequestDataProvider = new DvcsPullRequestDetailHelper(branchServiceAccessor, pullRequestServiceAccessor, repositoryServiceAccessor);
    }

    public void init(DvcsApplicationTypeInfo dvcsType) {
        this.dvcsType = (DvcsApplicationTypeInfo)Preconditions.checkNotNull((Object)dvcsType, (Object)"dvcsType");
        this.executor = this.createExecutorService();
    }

    @Override
    @Nonnull
    public Promise<DataProviderResponse> getDetailDataFutureFor(final @Nonnull IssueDataRequest detailDataRequest, final @Nonnull String type) {
        return Promises.forFuture(this.executor.submit(LoggingDecorator.decorate(type + " details for " + detailDataRequest.issueKeys(), new Callable<DataProviderResponse>(){

            @Override
            public DataProviderResponse call() {
                if (CommitsObject.ID.getId().equals(type)) {
                    return DvcsDataProvider.serialize(DvcsDataProvider.this.commitDataProvider.getCommitInfoMappedByRepository((Set<String>)detailDataRequest.issueKeys(), DvcsDataProvider.this.dvcsType, DvcsDataProvider.this.executor));
                }
                if (PullRequestsObject.ID.getId().equals(type) || BranchesObject.ID.getId().equals(type)) {
                    return DvcsDataProvider.serialize(DvcsDataProvider.this.pullRequestDataProvider.getPullRequestInfoMappedByRepository((Set<String>)detailDataRequest.issueKeys(), DvcsDataProvider.this.dvcsType));
                }
                return DataProviderResponse.failure(new ExceptionThrownError(new IllegalArgumentException("Unsupported type: " + type)));
            }
        })));
    }

    @Override
    public Source getSource() {
        return this.dvcsType.getSource();
    }

    @Override
    @Nonnull
    public Promise<DataProviderResponse> getSummaryDataFutureFor(final @Nonnull IssueDataRequest summaryRequest) {
        return Promises.forFuture(this.executor.submit(LoggingDecorator.decorate("summary for " + summaryRequest.issueKeys(), new Callable<DataProviderResponse>(){

            @Override
            public DataProviderResponse call() throws Exception {
                return DvcsDataProvider.serialize(DvcsDataProvider.this.getSummaryInfoMappedByIssueKeys((Set<String>)summaryRequest.issueKeys()));
            }
        })));
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @VisibleForTesting
    Summary getSummaryInfoMappedByIssueKeys(Set<String> issueKeys) {
        DvcsChangesetService changeset = (DvcsChangesetService)this.changesetServiceAccessor.getService();
        DvcsPullRequestService pullrequest = (DvcsPullRequestService)this.pullRequestServiceAccessor.getService();
        DvcsBranchService branch = (DvcsBranchService)this.branchServiceAccessor.getService();
        Summary.Builder targets = new Summary.Builder();
        for (String issueKey : issueKeys) {
            List pullrequests = pullrequest.getPullRequests(Collections.singleton(issueKey), this.dvcsType());
            targets.add(issueKey, (Iterable<? extends SummaryTarget>)ImmutableList.of((Object)this.getCommitInfoForIssueKey(changeset, issueKey), (Object)this.getPullrequestInfoForIssueKey(pullrequests), (Object)this.getBranchInfoForIssueKey(branch, pullrequests, issueKey)));
        }
        return targets.build();
    }

    @VisibleForTesting
    static DataProviderResponse serialize(Object root) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return DataProviderResponse.success(objectMapper.writeValueAsBytes(root));
        }
        catch (IOException e) {
            return DataProviderResponse.failure(e);
        }
    }

    @VisibleForTesting
    SummaryTarget getCommitInfoForIssueKey(DvcsChangesetService service, String issueKey) {
        List changesets = service.getChangesets(Collections.singleton(issueKey), this.dvcsType());
        return DvcsDataProvider.getRepoInfo(changesets);
    }

    @VisibleForTesting
    SummaryTarget getPullrequestInfoForIssueKey(Collection<PullRequest> pullrequests) {
        return pullrequests.isEmpty() ? new SummaryTarget.Builder(PullRequestsObject.ID).build() : new SummaryTarget.Builder(PullRequestsObject.ID).addAll(Collections2.transform(pullrequests, (Function)new Function<PullRequest, PullRequestsObject>(){

            public PullRequestsObject apply(PullRequest pullRequest) {
                return ((PullRequestsObject.Builder)new PullRequestsObject.Builder(PullRequestState.valueOf(pullRequest.getStatus())).lastUpdated(pullRequest.getUpdatedOn())).build();
            }
        })).build();
    }

    @VisibleForTesting
    SummaryTarget getBranchInfoForIssueKey(DvcsBranchService branchService, Collection<PullRequest> pullrequests, String issueKey) {
        List dvcsBranches = branchService.getBranches(Collections.singleton(issueKey), this.dvcsType());
        if (dvcsBranches.isEmpty() && pullrequests.isEmpty()) {
            return new SummaryTarget.Builder(BranchesObject.ID).build();
        }
        LinkedHashMultimap branchesByRepoId = LinkedHashMultimap.create();
        for (Branch branch : dvcsBranches) {
            branchesByRepoId.put((Object)branch.getRepositoryId(), (Object)branch.getName());
        }
        for (PullRequest pullrequest : pullrequests) {
            PullRequestRef source = pullrequest.getSource();
            Collection branches = branchesByRepoId.get((Object)pullrequest.getRepositoryId());
            if (source.getRepository() == null || branches != null && branches.contains(source.getBranch())) continue;
            branchesByRepoId.put((Object)pullrequest.getRepositoryId(), (Object)source.getBranch());
        }
        Collection summaryBranches = Collections2.transform(branchesByRepoId.asMap().entrySet(), (Function)new Function<Map.Entry<Integer, Collection<String>>, BranchesObject>(){

            public BranchesObject apply(Map.Entry<Integer, Collection<String>> entry) {
                return ((BranchesObject.Builder)new BranchesObject.Builder((List<String>)ImmutableList.copyOf(entry.getValue())).count(entry.getValue().size())).build();
            }
        });
        return new SummaryTarget.Builder(BranchesObject.ID).addAll(summaryBranches).build();
    }

    @VisibleForTesting
    static SummaryTarget getRepoInfo(Collection<Changeset> changesets) {
        return DvcsDataProvider.createInfo(DvcsDataProvider.extractRepos(changesets));
    }

    @VisibleForTesting
    static Iterable<CommitsObject> extractRepos(Collection<Changeset> changesets) {
        Multimap<Integer, Changeset> setsByRepo = DvcsDataProvider.coalesceByRepoId(changesets);
        ArrayList retVal = Lists.newArrayList();
        for (Map.Entry changes : setsByRepo.asMap().entrySet()) {
            Collection changeSet = (Collection)changes.getValue();
            Iterable commits = Iterables.transform((Iterable)changeSet, (Function)new Function<Changeset, String>(){

                public String apply(@Nullable Changeset o) {
                    return o.getNode();
                }
            });
            Date lastUpdated = (Date)Ordering.natural().max(Iterables.transform((Iterable)changeSet, (Function)new Function<Changeset, Date>(){

                public Date apply(@Nullable Changeset changeset) {
                    return changeset.getDate();
                }
            }));
            retVal.add(((CommitsObject.Builder)((CommitsObject.Builder)new CommitsObject.Builder((List<String>)ImmutableList.copyOf((Iterable)commits)).count(changeSet.size())).lastUpdated(lastUpdated)).type("git").build());
        }
        return retVal;
    }

    @VisibleForTesting
    static Multimap<Integer, Changeset> coalesceByRepoId(Collection<Changeset> changesets) {
        return Multimaps.index(changesets, (Function)new Function<Changeset, Integer>(){

            public Integer apply(@Nullable Changeset changeset) {
                return changeset.getRepositoryId();
            }
        });
    }

    @VisibleForTesting
    static SummaryTarget createInfo(Iterable<CommitsObject> objects) {
        return new SummaryTarget.Builder(CommitsObject.ID).addAll(objects).build();
    }

    @Override
    public void destroy() {
        this.executor.shutdownNow();
    }

    public String toString() {
        return String.format("%s[dvcsType=%s]", this.getClass().getSimpleName(), this.dvcsType());
    }

    @Nonnull
    private String dvcsType() {
        return this.dvcsType != null ? this.dvcsType.getType().getType() : "null";
    }

    private ExecutorService createExecutorService() {
        return ThreadPool.builder().name("dvcs." + this.dvcsType()).maxThreads(20).build();
    }
}

