/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.applink;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.fusion.schema.capability.DevStatusDetail;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderSource;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.ApplicationLinkDataProviderFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class CapabilityProviderSource
implements DataProviderSource {
    private final ApplicationLinkService applicationLinkService;
    private final LinkedApplicationCapabilities capabilities;
    private final ApplicationLinkDataProviderFactory dataProviderFactory;

    @Inject
    public CapabilityProviderSource(@ComponentImport ApplicationLinkService applicationLinkService, @ComponentImport LinkedApplicationCapabilities capabilities, ApplicationLinkDataProviderFactory dataProviderFactory) {
        this.applicationLinkService = applicationLinkService;
        this.capabilities = capabilities;
        this.dataProviderFactory = dataProviderFactory;
    }

    @Override
    public ImmutableList<DataProvider> availableProviders() {
        Set linkedApps = this.capabilities.capableOf("dev-status-summary");
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)linkedApps, (Function)new Function<LinkedAppWithCapabilities, DataProvider>(){

            public DataProvider apply(final LinkedAppWithCapabilities linkedApp) {
                try {
                    ApplicationLink applicationLink = CapabilityProviderSource.this.applicationLinkService.getApplicationLink(new ApplicationId(linkedApp.getApplicationLinkId()));
                    return applicationLink == null ? null : CapabilityProviderSource.this.dataProviderFactory.create(applicationLink, linkedApp.getCapabilityUrl("dev-status-summary"), new Function<String, String>(){

                        public String apply(String detailType) {
                            return linkedApp.getCapabilityUrl(DevStatusDetail.getCapability(detailType));
                        }
                    });
                }
                catch (TypeNotInstalledException e) {
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull()));
    }
}

