/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.TrustedAppsHelper;
import javax.annotation.Nullable;

public class ApplicationLinkSecurityHelper {
    static final String OAUTH_3LO_DISABLED = "jira.devstatus.oauth.3lo.disabled";
    private final ApplicationLink applicationLink;
    private final TrustedAppsHelper trustedAppsHelper;

    public ApplicationLinkSecurityHelper(ApplicationLink applicationLink, TrustedAppsHelper trustedAppsHelper) {
        this.applicationLink = applicationLink;
        this.trustedAppsHelper = trustedAppsHelper;
    }

    @Nullable
    public ApplicationLinkRequestFactory createRequestFactoryForSummary() {
        if (Boolean.getBoolean(OAUTH_3LO_DISABLED)) {
            return this.applicationLink.createAuthenticatedRequestFactory();
        }
        ApplicationLinkRequestFactory nonImpersonatingAuthenticatedRequestFactory = this.applicationLink.createAuthenticatedRequestFactory(TwoLeggedOAuthAuthenticationProvider.class);
        if (nonImpersonatingAuthenticatedRequestFactory != null) {
            return nonImpersonatingAuthenticatedRequestFactory;
        }
        return this.trustedAppsHelper.createRequestFactoryWithImpersonation(this.applicationLink);
    }

    @Nullable
    public ApplicationLinkRequestFactory createRequestFactoryForDetails() {
        return this.createAuthenticatedRequestFactoryForDetails();
    }

    @Nullable
    public ApplicationLinkRequestFactory createAuthenticatedRequestFactoryForDetails() {
        return this.applicationLink.createAuthenticatedRequestFactory();
    }
}

