/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.core.util.Clock;
import com.atlassian.fusion.schema.capability.DevStatusDetail;
import com.atlassian.fusion.schema.capability.DevStatusSummary;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.IssueDataRequest;
import com.atlassian.jira.plugin.devstatus.provider.LoggingDecorator;
import com.atlassian.jira.plugin.devstatus.provider.data.ExceptionThrownError;
import com.atlassian.jira.plugin.devstatus.provider.data.IncapableError;
import com.atlassian.jira.plugin.devstatus.provider.data.NotConfiguredError;
import com.atlassian.jira.plugin.devstatus.provider.data.RateLimitExceededError;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.data.UnauthorizedError;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.ApplicationLinkRateLimiter;
import com.atlassian.jira.plugin.devstatus.provider.source.applink.ApplicationLinkSecurityHelper;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLinkDataProvider
implements DataProvider {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinkDataProvider.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;
    private final ApplicationLink applicationLink;
    private final ExecutorService executor;
    private final I18nHelper i18nHelper;
    private final String summaryUrl;
    private final Function<String, String> detailUrlLookup;
    private final Clock clock;
    private final ApplicationLinkRateLimiter rateLimiter;
    private final ApplicationLinkSecurityHelper securityHelper;

    public ApplicationLinkDataProvider(ApplicationLink applicationLink, Function<String, String> detailUrlLookup, ExecutorService executor, I18nHelper i18nHelper, String summaryUrl, ApplicationLinkRateLimiter rateLimiter, Clock clock, ApplicationLinkSecurityHelper securityHelper) {
        this.applicationLink = applicationLink;
        this.executor = executor;
        this.i18nHelper = i18nHelper;
        this.summaryUrl = summaryUrl;
        this.detailUrlLookup = detailUrlLookup;
        this.clock = clock;
        this.rateLimiter = rateLimiter;
        this.securityHelper = securityHelper;
    }

    @Override
    public Source getSource() {
        return new NavigationLinkSource(this.applicationLink, this.i18nHelper);
    }

    @Override
    @Nonnull
    public Promise<DataProviderResponse> getSummaryDataFutureFor(@Nonnull IssueDataRequest summaryRequest) {
        ApplicationLinkRequestFactory requestFactory = this.securityHelper.createRequestFactoryForSummary();
        if (requestFactory == null) {
            return Promises.promise((Object)DataProviderResponse.failure(new NotConfiguredError()));
        }
        try {
            Promise<DataProviderResponse> data = this.getData(this.summaryUrl + "?" + DevStatusSummary.toQueryParams(summaryRequest.issueKeys()), requestFactory);
            return data.map((Function)new UnauthorizedToNotConfigured());
        }
        catch (Exception e) {
            return ApplicationLinkDataProvider.failWithPromise(e);
        }
    }

    @Override
    @Nonnull
    public Promise<DataProviderResponse> getDetailDataFutureFor(@Nonnull IssueDataRequest detailDataRequest, @Nonnull String type) {
        String detailTypeUrl = (String)this.detailUrlLookup.apply((Object)type);
        if (detailTypeUrl == null) {
            return Promises.promise((Object)ApplicationLinkDataProvider.incapable());
        }
        try {
            ApplicationLinkRequestFactory requestFactory = this.securityHelper.createRequestFactoryForDetails();
            return this.getData(detailTypeUrl + "?" + DevStatusDetail.toQueryParams(detailDataRequest.issueKeys()), requestFactory);
        }
        catch (CredentialsRequiredException e) {
            return Promises.promise((Object)ApplicationLinkDataProvider.unauthorized());
        }
        catch (Exception e) {
            return ApplicationLinkDataProvider.failWithPromise(e);
        }
    }

    @Override
    public boolean isConfigured() {
        return this.securityHelper.createRequestFactoryForDetails() != null && this.securityHelper.createRequestFactoryForSummary() != null;
    }

    @Override
    public boolean isAuthenticated() {
        ApplicationLinkRequestFactory requestFactory = this.securityHelper.createAuthenticatedRequestFactoryForDetails();
        if (requestFactory != null) {
            try {
                requestFactory.createRequest(Request.MethodType.GET, this.applicationLink.getRpcUrl().toString());
                return true;
            }
            catch (CredentialsRequiredException credentialsRequiredException) {
                // empty catch block
            }
        }
        return false;
    }

    private Promise<DataProviderResponse> getData(final String url, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException {
        final ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, url);
        return Promises.forFuture(this.executor.submit(LoggingDecorator.decorate(url, new RateLimitedCallable(this.rateLimiter, this.applicationLink){

            @Override
            public DataProviderResponse execute() {
                try {
                    return this.executeRequest();
                }
                catch (ResponseException e) {
                    return ApplicationLinkDataProvider.handleResponseException(e);
                }
                catch (Exception e) {
                    return ApplicationLinkDataProvider.fail(e);
                }
            }

            private DataProviderResponse executeRequest() throws ResponseException {
                request.setConnectionTimeout(Integer.getInteger("jira.devstatus.capability.connection.timeout", 10000).intValue());
                return (DataProviderResponse)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<DataProviderResponse>(){

                    public DataProviderResponse credentialsRequired(Response response) throws ResponseException {
                        return ApplicationLinkDataProvider.unauthorized();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public DataProviderResponse handle(Response response) throws ResponseException {
                        if (!response.isSuccessful()) {
                            int statusCode = response.getStatusCode();
                            if (statusCode == 404 || statusCode == 500) {
                                if (log.isDebugEnabled() && statusCode == 500) {
                                    log.debug("Error connecting to '{}' - {}: '{}'\n{}", new Object[]{url, statusCode, response.getStatusText(), response.getResponseBodyAsString()});
                                } else {
                                    log.warn("Error connecting to '{}' - {}: '{}'", new Object[]{url, statusCode, response.getStatusText()});
                                }
                            }
                            if (statusCode == 401) {
                                return ApplicationLinkDataProvider.unauthorized();
                            }
                            return ApplicationLinkDataProvider.failQuiet((Exception)new ResponseException(response.getStatusText()));
                        }
                        InputStream in = response.getResponseBodyAsStream();
                        try {
                            DataProviderResponse dataProviderResponse = DataProviderResponse.success(IOUtils.toByteArray((InputStream)in), ApplicationLinkDataProvider.this.getMaxAge(response));
                            return dataProviderResponse;
                        }
                        catch (IOException e) {
                            DataProviderResponse dataProviderResponse = ApplicationLinkDataProvider.fail(e);
                            return dataProviderResponse;
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)in);
                        }
                    }
                });
            }
        })));
    }

    @Nullable
    private Date getMaxAge(Response response) {
        try {
            CacheControl cacheControl;
            String header = response.getHeader("Cache-Control");
            CacheControl cacheControl2 = cacheControl = header != null ? CacheControl.valueOf((String)header) : null;
            if (cacheControl == null || cacheControl.getMaxAge() == -1) {
                return null;
            }
            DateTime now = new DateTime((Object)this.clock.getCurrentDate());
            return now.plusSeconds(cacheControl.getMaxAge()).toDate();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void destroy() {
    }

    private static DataProviderResponse unauthorized() {
        return DataProviderResponse.failure(new UnauthorizedError());
    }

    private static DataProviderResponse incapable() {
        return DataProviderResponse.failure(new IncapableError());
    }

    private static DataProviderResponse handleResponseException(ResponseException e) {
        if ("Unauthorized".equals(e.getMessage())) {
            return ApplicationLinkDataProvider.unauthorized();
        }
        return ApplicationLinkDataProvider.fail((Exception)((Object)e));
    }

    private static Promise<DataProviderResponse> failWithPromise(Exception e) {
        return ApplicationLinkDataProvider.failWithPromise(e, true);
    }

    private static Promise<DataProviderResponse> failWithPromise(Exception e, boolean warn) {
        return Promises.promise((Object)ApplicationLinkDataProvider.fail(e, warn));
    }

    private static DataProviderResponse fail(Exception e) {
        return ApplicationLinkDataProvider.fail(e, true);
    }

    private static DataProviderResponse fail(Exception e, boolean warn) {
        if (warn) {
            log.warn(e.getMessage());
        } else {
            log.info(e.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return ApplicationLinkDataProvider.failQuiet(e);
    }

    private static DataProviderResponse failQuiet(Exception e) {
        return DataProviderResponse.failure(new ExceptionThrownError(e));
    }

    private static abstract class RateLimitedCallable
    implements Callable<DataProviderResponse> {
        protected final ApplicationLinkRateLimiter rateLimiter;
        protected final ApplicationLink applicationLink;

        protected RateLimitedCallable(ApplicationLinkRateLimiter rateLimiter, ApplicationLink applicationLink) {
            this.rateLimiter = rateLimiter;
            this.applicationLink = applicationLink;
        }

        @Override
        public final DataProviderResponse call() throws Exception {
            if (!this.rateLimiter.tryAcquire(this.applicationLink)) {
                return DataProviderResponse.failure(new RateLimitExceededError(this.rateLimiter.getRate(this.applicationLink)));
            }
            return this.execute();
        }

        protected abstract DataProviderResponse execute();
    }

    private static class UnauthorizedToNotConfigured
    implements Function<DataProviderResponse, DataProviderResponse> {
        private UnauthorizedToNotConfigured() {
        }

        public DataProviderResponse apply(DataProviderResponse response) {
            if (!response.isSuccessful() && response.error() instanceof UnauthorizedError) {
                return DataProviderResponse.failure(new NotConfiguredError());
            }
            return response;
        }
    }

    public static class NavigationLinkSource
    implements Source {
        private final ApplicationLink applicationLink;
        private final I18nHelper i18nHelper;

        private NavigationLinkSource(ApplicationLink applicationLink, I18nHelper i18nHelper) {
            this.applicationLink = applicationLink;
            this.i18nHelper = i18nHelper;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.applicationLink.getName();
        }

        @Override
        @Nonnull
        public String getBaseUrl() {
            return this.applicationLink.getDisplayUrl().toASCIIString();
        }

        @Override
        @Nonnull
        public String getType() {
            return this.applicationLink.getType().getI18nKey().replace("applinks.", "");
        }

        @Override
        @Nonnull
        public String getId() {
            return this.getApplicationLinkId();
        }

        @Override
        @Nonnull
        public String getTypeName() {
            return this.i18nHelper.getText(this.applicationLink.getType().getI18nKey());
        }

        @Nonnull
        @JsonProperty
        public String getApplicationLinkId() {
            return this.applicationLink.getId().get();
        }

        public String toString() {
            return "[" + this.getType() + ", " + this.getName() + ", " + this.getApplicationLinkId() + "]";
        }

        @Override
        @JsonProperty
        public boolean isSingleInstance() {
            return false;
        }

        @JsonProperty
        public boolean isPrimary() {
            return this.applicationLink.isPrimary();
        }
    }
}

