/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider.source;

import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPool.class);

    public static Builder builder() {
        return new Builder();
    }

    private ThreadPool() {
    }

    public static class Builder {
        private String name = null;
        private int coreThreads = 0;
        private int maxThreads = Integer.MAX_VALUE;
        private Period keepAlive = Period.seconds((int)60);
        private QueueType queueType = new DirectHandoff();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder coreThreads(int coreThreads) {
            this.coreThreads = coreThreads;
            return this;
        }

        public Builder maxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder keepAlive(Period keepAlive) {
            this.keepAlive = (Period)Preconditions.checkNotNull((Object)keepAlive, (Object)"keepAlive");
            return this;
        }

        public Builder synchronousQueue() {
            this.queueType = new DirectHandoff();
            return this;
        }

        public Builder boundedQueue(int queueSize) {
            this.queueType = new LinkedBlocking(queueSize);
            return this;
        }

        public Builder unboundedQueue() {
            return this.boundedQueue(Integer.MAX_VALUE);
        }

        public ListeningExecutorService build() {
            if (this.name == null) {
                throw new IllegalStateException("no name provided for thread pool");
            }
            EffectiveConfig poolConfig = new EffectiveConfig();
            logger.info("Creating new thread pool with configuration: {}", (Object)poolConfig);
            return MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(poolConfig.coreThreads, poolConfig.poolSize, (long)poolConfig.keepAliveTime, TimeUnit.SECONDS, poolConfig.queue.createQueue(), ThreadFactories.namedThreadFactory((String)poolConfig.name, (ThreadFactories.Type)ThreadFactories.Type.DAEMON)));
        }

        private int getConfigured(String property, int fallback) {
            Integer defaultValue = Integer.getInteger(String.format("jira.devstatus.%s", property), fallback);
            return Integer.getInteger(String.format("jira.devstatus.%s.%s", this.name, property), defaultValue);
        }

        private class LinkedBlocking
        extends QueueType {
            private final int queueSize;

            public LinkedBlocking(int queueSize) {
                this.queueSize = queueSize;
            }

            @Override
            public BlockingQueue<Runnable> createQueue() {
                return new LinkedBlockingQueue<Runnable>(Builder.this.getConfigured("queue.size", this.queueSize));
            }
        }

        private class DirectHandoff
        extends QueueType {
            private DirectHandoff() {
            }

            @Override
            public BlockingQueue<Runnable> createQueue() {
                return new SynchronousQueue<Runnable>();
            }
        }

        private abstract class QueueType {
            private QueueType() {
            }

            abstract BlockingQueue<Runnable> createQueue();

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            }
        }

        class EffectiveConfig {
            final String name;
            final int coreThreads;
            final int poolSize;
            final int keepAliveTime;
            final QueueType queue;

            EffectiveConfig() {
                this.name = "devstatus." + Builder.this.name;
                this.coreThreads = Builder.this.getConfigured("core.threads", Builder.this.coreThreads);
                this.poolSize = Builder.this.getConfigured("max.threads", Builder.this.maxThreads);
                this.keepAliveTime = Builder.this.getConfigured("keep.alive", Builder.this.keepAlive.getSeconds());
                this.queue = Builder.this.queueType;
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            }
        }
    }
}

