/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.devstatus.provider;

import com.atlassian.fugue.Pair;
import com.atlassian.guava.collect.Lists;
import com.atlassian.jira.plugin.devstatus.impl.RequestTimeoutHelper;
import com.atlassian.jira.plugin.devstatus.provider.Coordinator;
import com.atlassian.jira.plugin.devstatus.provider.DataProvider;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderHelper;
import com.atlassian.jira.plugin.devstatus.provider.DataProviderResponse;
import com.atlassian.jira.plugin.devstatus.provider.IssueDataRequest;
import com.atlassian.jira.plugin.devstatus.provider.data.ExceptionThrownError;
import com.atlassian.jira.plugin.devstatus.provider.data.Source;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryData;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryDataBuilder;
import com.atlassian.jira.plugin.devstatus.provider.data.SummaryDataItem;
import com.atlassian.jira.plugin.devstatus.provider.data.TimedOutError;
import com.atlassian.jira.plugin.devstatus.provider.source.cache.DevSummaryStore;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.atlassian.util.concurrent.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultCoordinator
implements Coordinator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCoordinator.class);
    private static final Function<DataProvider, String> TO_SOURCE_TYPE = new Function<DataProvider, String>(){

        public String apply(DataProvider provider) {
            return provider.getSource().getType();
        }
    };
    private final DataProviderHelper dataProviderHelper;
    private final DevSummaryStore devSummaryStore;
    private final RequestTimeoutHelper requestTimeoutHelper;

    @Inject
    public DefaultCoordinator(DataProviderHelper dataProviderHelper, DevSummaryStore devSummaryStore, RequestTimeoutHelper requestTimeoutHelper) {
        this.dataProviderHelper = dataProviderHelper;
        this.devSummaryStore = devSummaryStore;
        this.requestTimeoutHelper = requestTimeoutHelper;
    }

    @Override
    @Nonnull
    public SummaryData fetchDetailData(final @Nonnull IssueDataRequest detailDataRequest, @Nonnull String applicationType, final @Nonnull String dataType) {
        Preconditions.checkNotNull((Object)applicationType, (Object)"applicationType");
        Preconditions.checkNotNull((Object)dataType, (Object)"dataType");
        Collection providers = Collections2.filter(this.dataProviderHelper.getDataProviders(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)applicationType), TO_SOURCE_TYPE));
        return this.combineProviderResponses(providers, new Function<DataProvider, Promise<DataProviderResponse>>(){

            public Promise<DataProviderResponse> apply(DataProvider provider) {
                return provider.getDetailDataFutureFor(detailDataRequest, dataType);
            }
        }, this.requestTimeoutHelper.getDetailsTimeout(), false, detailDataRequest);
    }

    @Override
    public SummaryData fetchSummaryData(final @Nonnull IssueDataRequest summaryRequest) {
        return this.combineProviderResponses(this.dataProviderHelper.getDataProviders(), new Function<DataProvider, Promise<DataProviderResponse>>(){

            public Promise<DataProviderResponse> apply(DataProvider provider) {
                return provider.getSummaryDataFutureFor(summaryRequest);
            }
        }, this.requestTimeoutHelper.getSummaryTimeOut(), true, summaryRequest);
    }

    @VisibleForTesting
    SummaryData combineProviderResponses(Collection<DataProvider> providers, Function<DataProvider, Promise<DataProviderResponse>> callback, long timeoutMillis, boolean getFromCacheWhenTimeout, @Nonnull IssueDataRequest issueDataRequest) {
        Preconditions.checkNotNull((Object)issueDataRequest, (Object)"issueDataRequest");
        if (providers.isEmpty()) {
            return SummaryData.builder().build();
        }
        ArrayList<Pair> providerResponses = Lists.newArrayListWithCapacity(providers.size());
        for (DataProvider provider : providers) {
            try {
                providerResponses.add(Pair.pair((Object)provider.getSource(), (Object)((Promise)callback.apply((Object)provider)).recover((Function)ThrowableToFetchError.INSTANCE)));
            }
            catch (Exception e) {
                providerResponses.add(Pair.pair((Object)provider.getSource(), (Object)Promises.promise((Object)DataProviderResponse.failure(e))));
            }
        }
        SummaryDataBuilder builder = SummaryData.builder();
        Timeout timeout = Timeout.getMillisTimeout((long)timeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        for (Pair provider : providerResponses) {
            Source providerSource = (Source)provider.left();
            Promise response = (Promise)provider.right();
            try {
                builder.addResponse(providerSource, (DataProviderResponse)response.get(timeout.getTime(), timeout.getUnit()));
            }
            catch (TimeoutException e) {
                DataProviderResponse cachedResponse;
                boolean cacheUsed = false;
                if (getFromCacheWhenTimeout && (cachedResponse = this.devSummaryStore.get(issueDataRequest.issueId(), providerSource.getId())) != null) {
                    builder.addSuccess(providerSource, cachedResponse.jsonBytes());
                    cacheUsed = true;
                }
                builder.addFailure(providerSource, new TimedOutError(getFromCacheWhenTimeout, cacheUsed, timeoutMillis));
            }
            catch (Exception e) {
                builder.addFailure(providerSource, new ExceptionThrownError(e));
            }
        }
        return this.logFailureAndReturn(builder.build());
    }

    private SummaryData logFailureAndReturn(SummaryData summaryData) {
        if (logger.isDebugEnabled()) {
            for (SummaryDataItem summaryDataItem : summaryData.getItems()) {
                if (summaryDataItem.getResult().isSuccessful()) continue;
                logger.debug("request to data provider {} failed: {}", (Object)summaryDataItem.getSource(), (Object)summaryDataItem.getResult().error());
            }
        }
        return summaryData;
    }

    private static enum ThrowableToFetchError implements Function<Throwable, DataProviderResponse>
    {
        INSTANCE;


        public DataProviderResponse apply(Throwable throwable) {
            return DataProviderResponse.failure(throwable);
        }
    }
}

